/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FloatType
extends DataType<Float>
implements Streamer<Float>,
FixedWidthType {
    public static final FloatType INSTANCE = new FloatType();
    public static final int ID = 7;
    private static final int FLOAT_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Float.class);

    private FloatType() {
    }

    @Override
    public int id() {
        return 7;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.FLOAT;
    }

    @Override
    public String getName() {
        return "real";
    }

    @Override
    public Streamer<Float> streamer() {
        return this;
    }

    @Override
    public Float implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            BigInteger MAX = BigDecimal.valueOf(3.4028234663852886E38).toBigInteger();
            BigInteger MIN = BigDecimal.valueOf(-3.4028234663852886E38).toBigInteger();
            if (MAX.compareTo(bigDecimalValue.toBigInteger()) <= 0 || MIN.compareTo(bigDecimalValue.toBigInteger()) >= 0) {
                throw new IllegalArgumentException("float value out of range: " + value);
            }
            return Float.valueOf(bigDecimalValue.floatValue());
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            float val = number.floatValue();
            if (Float.isInfinite(val) && !Double.isInfinite(number.doubleValue())) {
                throw new IllegalArgumentException("float value out of range: " + value);
            }
            return Float.valueOf(val);
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Float sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        return Float.valueOf(((Number)value).floatValue());
    }

    @Override
    public int compare(Float val1, Float val2) {
        return Float.compare(val1.floatValue(), val2.floatValue());
    }

    @Override
    public Float readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Float.valueOf(in.readFloat());
    }

    @Override
    public void writeValueTo(StreamOutput out, Float v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeFloat(v.floatValue());
        }
    }

    @Override
    public int fixedSize() {
        return FLOAT_SIZE;
    }
}

