/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DoubleType
extends DataType<Double>
implements FixedWidthType,
Streamer<Double> {
    public static final DoubleType INSTANCE = new DoubleType();
    public static final int ID = 6;
    private static final int DOUBLE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Double.class);

    private DoubleType() {
    }

    @Override
    public int id() {
        return 6;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.DOUBLE;
    }

    @Override
    public String getName() {
        return "double precision";
    }

    @Override
    public Streamer<Double> streamer() {
        return this;
    }

    @Override
    public Double implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            BigInteger DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE).toBigInteger();
            BigInteger DOUBLE_MIN = BigDecimal.valueOf(-1.7976931348623157E308).toBigInteger();
            if (DOUBLE_MAX.compareTo(bigDecimalValue.toBigInteger()) <= 0 || DOUBLE_MIN.compareTo(bigDecimalValue.toBigInteger()) >= 0) {
                throw new IllegalArgumentException(this.getName() + " value out of range: " + value);
            }
            return bigDecimalValue.doubleValue();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Double sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public int compare(Double val1, Double val2) {
        return Double.compare(val1, val2);
    }

    @Override
    public Double readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Double.valueOf(in.readDouble());
    }

    @Override
    public void writeValueTo(StreamOutput out, Double v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeDouble(v);
        }
    }

    @Override
    public int fixedSize() {
        return DOUBLE_SIZE;
    }
}

