/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.ArrayType;
import io.crate.types.BooleanType;
import io.crate.types.ByteType;
import io.crate.types.DataType;
import io.crate.types.DoubleType;
import io.crate.types.FloatType;
import io.crate.types.GeoPointType;
import io.crate.types.GeoShapeType;
import io.crate.types.IntegerType;
import io.crate.types.IntervalType;
import io.crate.types.IpType;
import io.crate.types.LongType;
import io.crate.types.NotSupportedType;
import io.crate.types.NumericType;
import io.crate.types.ObjectType;
import io.crate.types.OidVectorType;
import io.crate.types.RegprocType;
import io.crate.types.RowType;
import io.crate.types.ShortType;
import io.crate.types.StringType;
import io.crate.types.TimeTZType;
import io.crate.types.TimestampType;
import io.crate.types.UncheckedObjectType;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.locationtech.spatial4j.shape.jts.JtsPoint;

public final class DataTypes {
    private static final Logger LOGGER = LogManager.getLogger(DataTypes.class);
    public static final UndefinedType UNDEFINED = UndefinedType.INSTANCE;
    public static final NotSupportedType NOT_SUPPORTED = NotSupportedType.INSTANCE;
    public static final ByteType BYTE = ByteType.INSTANCE;
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final StringType STRING = StringType.INSTANCE;
    public static final IpType IP = IpType.INSTANCE;
    public static final DoubleType DOUBLE = DoubleType.INSTANCE;
    public static final FloatType FLOAT = FloatType.INSTANCE;
    public static final ShortType SHORT = ShortType.INSTANCE;
    public static final IntegerType INTEGER = IntegerType.INSTANCE;
    public static final LongType LONG = LongType.INSTANCE;
    public static final NumericType NUMERIC = NumericType.INSTANCE;
    public static final TimeTZType TIMETZ = TimeTZType.INSTANCE;
    public static final TimestampType TIMESTAMPZ = TimestampType.INSTANCE_WITH_TZ;
    public static final TimestampType TIMESTAMP = TimestampType.INSTANCE_WITHOUT_TZ;
    public static final GeoPointType GEO_POINT = GeoPointType.INSTANCE;
    public static final GeoShapeType GEO_SHAPE = GeoShapeType.INSTANCE;
    public static final ArrayType<Double> DOUBLE_ARRAY = new ArrayType<Double>(DOUBLE);
    public static final ArrayType<Float> FLOAT_ARRAY = new ArrayType<Float>(FLOAT);
    public static final ArrayType<String> STRING_ARRAY = new ArrayType<String>(STRING);
    public static final ArrayType<Integer> INTEGER_ARRAY = new ArrayType<Integer>(INTEGER);
    public static final ArrayType<Short> SHORT_ARRAY = new ArrayType<Short>(SHORT);
    public static final ArrayType<Long> BIGINT_ARRAY = new ArrayType<Long>(LONG);
    public static final ArrayType<Boolean> BOOLEAN_ARRAY = new ArrayType<Boolean>(BOOLEAN);
    public static final OidVectorType OIDVECTOR = new OidVectorType();
    public static final IntervalType INTERVAL = IntervalType.INSTANCE;
    public static final ObjectType UNTYPED_OBJECT = ObjectType.UNTYPED;
    public static final RegprocType REGPROC = RegprocType.INSTANCE;
    public static Set<String> PRIMITIVE_TYPE_NAMES_WITH_SPACES = Set.of(TIMESTAMPZ.getName(), TIMESTAMP.getName(), TIMETZ.getName(), DOUBLE.getName());
    public static final List<DataType<?>> PRIMITIVE_TYPES = List.of(BYTE, BOOLEAN, STRING, IP, DOUBLE, FLOAT, SHORT, INTEGER, INTERVAL, LONG, TIMESTAMPZ, TIMESTAMP);
    private static final Set<Integer> PRIMITIVE_TYPE_IDS = PRIMITIVE_TYPES.stream().map(DataType::id).collect(Collectors.toSet());
    public static final Set<DataType<?>> STORAGE_UNSUPPORTED = Set.of(INTERVAL, TIMETZ, OIDVECTOR, NUMERIC);
    public static final List<DataType<?>> NUMERIC_PRIMITIVE_TYPES = List.of(DOUBLE, FLOAT, BYTE, SHORT, INTEGER, LONG);
    private static final Set<Integer> NUMERIC_PRIMITIVE_TYPE_IDS = NUMERIC_PRIMITIVE_TYPES.stream().map(DataType::id).collect(Collectors.toSet());
    private static final Map<Integer, Writeable.Reader<DataType<?>>> TYPE_REGISTRY = new HashMap(Map.ofEntries(Map.entry(0, in -> UNDEFINED), Map.entry(1, in -> NOT_SUPPORTED), Map.entry(2, in -> BYTE), Map.entry(3, in -> BOOLEAN), Map.entry(4, StringType::new), Map.entry(5, in -> IP), Map.entry(6, in -> DOUBLE), Map.entry(7, in -> FLOAT), Map.entry(8, in -> SHORT), Map.entry(9, in -> INTEGER), Map.entry(10, in -> LONG), Map.entry(22, NumericType::new), Map.entry(20, in -> TIMETZ), Map.entry(11, in -> TIMESTAMPZ), Map.entry(15, in -> TIMESTAMP), Map.entry(12, ObjectType::new), Map.entry(16, in -> UncheckedObjectType.INSTANCE), Map.entry(13, in -> GEO_POINT), Map.entry(14, in -> GEO_SHAPE), Map.entry(100, ArrayType::new), Map.entry(17, in -> INTERVAL), Map.entry(18, RowType::new), Map.entry(19, in -> REGPROC), Map.entry(21, in -> OIDVECTOR)));
    private static final Set<Integer> NUMBER_CONVERSIONS = Stream.concat(Stream.of(BOOLEAN, STRING, TIMESTAMPZ, TIMESTAMP, IP, NUMERIC), NUMERIC_PRIMITIVE_TYPES.stream()).map(DataType::id).collect(Collectors.toSet());
    static final Map<Integer, Set<Integer>> ALLOWED_CONVERSIONS = Map.ofEntries(Map.entry(BYTE.id(), NUMBER_CONVERSIONS), Map.entry(SHORT.id(), NUMBER_CONVERSIONS), Map.entry(INTEGER.id(), Stream.concat(NUMBER_CONVERSIONS.stream(), Stream.of(Integer.valueOf(19))).collect(Collectors.toUnmodifiableSet())), Map.entry(REGPROC.id(), Set.of(Integer.valueOf(STRING.id()), Integer.valueOf(INTEGER.id()))), Map.entry(LONG.id(), NUMBER_CONVERSIONS), Map.entry(NUMERIC.id(), NUMBER_CONVERSIONS), Map.entry(FLOAT.id(), NUMBER_CONVERSIONS), Map.entry(DOUBLE.id(), NUMBER_CONVERSIONS), Map.entry(BOOLEAN.id(), Set.of(Integer.valueOf(STRING.id()))), Map.entry(STRING.id(), Stream.concat(Stream.of(GEO_SHAPE.id(), GEO_POINT.id(), 12, 19, 20), NUMBER_CONVERSIONS.stream()).collect(Collectors.toSet())), Map.entry(IP.id(), Set.of(Integer.valueOf(STRING.id()))), Map.entry(TIMESTAMPZ.id(), Set.of(Integer.valueOf(DOUBLE.id()), Integer.valueOf(LONG.id()), Integer.valueOf(STRING.id()), Integer.valueOf(TIMESTAMP.id()))), Map.entry(TIMESTAMP.id(), Set.of(Integer.valueOf(DOUBLE.id()), Integer.valueOf(LONG.id()), Integer.valueOf(STRING.id()), Integer.valueOf(TIMESTAMPZ.id()))), Map.entry(UNDEFINED.id(), Set.of()), Map.entry(GEO_POINT.id(), Set.of()), Map.entry(GEO_SHAPE.id(), Set.of(Integer.valueOf(12))), Map.entry(12, Set.of(Integer.valueOf(GEO_SHAPE.id()))), Map.entry(100, Set.of()));
    private static final Map<Integer, Set<DataType<?>>> SAFE_CONVERSIONS = Map.of(BYTE.id(), Set.of(SHORT, INTEGER, LONG, TIMESTAMPZ, TIMESTAMP, FLOAT, DOUBLE), SHORT.id(), Set.of(INTEGER, LONG, TIMESTAMPZ, TIMESTAMP, FLOAT, DOUBLE), INTEGER.id(), Set.of(LONG, TIMESTAMPZ, TIMESTAMP, FLOAT, DOUBLE), LONG.id(), Set.of(TIMESTAMPZ, TIMESTAMP, DOUBLE), FLOAT.id(), Set.of(DOUBLE));
    private static final Map<Class<?>, DataType<?>> POJO_TYPE_MAPPING = Map.ofEntries(Map.entry(Double.class, DOUBLE), Map.entry(Float.class, FLOAT), Map.entry(Integer.class, INTEGER), Map.entry(Long.class, LONG), Map.entry(Short.class, SHORT), Map.entry(Byte.class, BYTE), Map.entry(Boolean.class, BOOLEAN), Map.entry(Map.class, UNTYPED_OBJECT), Map.entry(String.class, STRING), Map.entry(BytesRef.class, STRING), Map.entry(PointImpl.class, GEO_POINT), Map.entry(JtsPoint.class, GEO_POINT), Map.entry(Character.class, STRING));
    private static final Map<String, DataType<?>> TYPES_BY_NAME_OR_ALIAS = Map.ofEntries(Map.entry(UNDEFINED.getName(), UNDEFINED), Map.entry(BYTE.getName(), BYTE), Map.entry(BOOLEAN.getName(), BOOLEAN), Map.entry(STRING.getName(), STRING), Map.entry(IP.getName(), IP), Map.entry(DOUBLE.getName(), DOUBLE), Map.entry(FLOAT.getName(), FLOAT), Map.entry(SHORT.getName(), SHORT), Map.entry(INTEGER.getName(), INTEGER), Map.entry(LONG.getName(), LONG), Map.entry(NUMERIC.getName(), NUMERIC), Map.entry(RowType.EMPTY.getName(), RowType.EMPTY), Map.entry(TIMETZ.getName(), TIMETZ), Map.entry(TIMESTAMPZ.getName(), TIMESTAMPZ), Map.entry(TIMESTAMP.getName(), TIMESTAMP), Map.entry("object", UNTYPED_OBJECT), Map.entry(GEO_POINT.getName(), GEO_POINT), Map.entry(GEO_SHAPE.getName(), GEO_SHAPE), Map.entry(REGPROC.getName(), REGPROC), Map.entry(OIDVECTOR.getName(), OIDVECTOR), Map.entry("int2", SHORT), Map.entry("int", INTEGER), Map.entry("int4", INTEGER), Map.entry("int8", LONG), Map.entry("name", STRING), Map.entry("long", LONG), Map.entry("byte", BYTE), Map.entry("short", SHORT), Map.entry("float", FLOAT), Map.entry("double", DOUBLE), Map.entry("string", STRING), Map.entry("varchar", STRING), Map.entry("character varying", STRING), Map.entry("timetz", TIMETZ), Map.entry("timestamptz", TIMESTAMPZ), Map.entry("timestamp", TIMESTAMPZ), Map.entry("interval", INTERVAL));
    private static final Map<String, DataType<?>> MAPPING_NAMES_TO_TYPES = Map.ofEntries(Map.entry("date", TIMESTAMPZ), Map.entry("string", STRING), Map.entry("keyword", STRING), Map.entry("text", STRING), Map.entry("boolean", BOOLEAN), Map.entry("byte", BYTE), Map.entry("short", SHORT), Map.entry("integer", INTEGER), Map.entry("long", LONG), Map.entry("float", FLOAT), Map.entry("double", DOUBLE), Map.entry("ip", IP), Map.entry("geo_point", GEO_POINT), Map.entry("geo_shape", GEO_SHAPE), Map.entry("object", UNTYPED_OBJECT), Map.entry("nested", UNTYPED_OBJECT), Map.entry("interval", INTERVAL));
    private static final Map<Integer, String> TYPE_IDS_TO_MAPPINGS = Map.ofEntries(Map.entry(TIMESTAMPZ.id(), "date"), Map.entry(TIMESTAMP.id(), "date"), Map.entry(STRING.id(), "text"), Map.entry(BYTE.id(), "byte"), Map.entry(BOOLEAN.id(), "boolean"), Map.entry(IP.id(), "ip"), Map.entry(DOUBLE.id(), "double"), Map.entry(FLOAT.id(), "float"), Map.entry(SHORT.id(), "short"), Map.entry(INTEGER.id(), "integer"), Map.entry(LONG.id(), "long"), Map.entry(12, "object"), Map.entry(GEO_SHAPE.id(), "geo_shape"), Map.entry(GEO_POINT.id(), "geo_point"), Map.entry(INTERVAL.id(), "interval"));

    public static boolean isArray(DataType<?> type) {
        return type.id() == 100;
    }

    public static List<DataType<?>> listFromStream(StreamInput in) throws IOException {
        return in.readList(DataTypes::fromStream);
    }

    public static DataType<?> fromStream(StreamInput in) throws IOException {
        int i = in.readVInt();
        try {
            return TYPE_REGISTRY.get(i).read(in);
        }
        catch (NullPointerException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "%d is missing in TYPE_REGISTRY", i), (Throwable)e);
            throw e;
        }
    }

    public static void toStream(Collection<? extends DataType<?>> types, StreamOutput out) throws IOException {
        out.writeVInt(types.size());
        for (DataType<?> type : types) {
            DataTypes.toStream(type, out);
        }
    }

    public static void toStream(DataType<?> type, StreamOutput out) throws IOException {
        out.writeVInt(type.id());
        type.writeTo(out);
    }

    public static DataType<?> guessType(Object value) {
        if (value == null) {
            return UNDEFINED;
        }
        if (value instanceof Map) {
            return UNTYPED_OBJECT;
        }
        if (value instanceof List) {
            return DataTypes.valueFromList((List)value);
        }
        if (value.getClass().isArray()) {
            return DataTypes.valueFromList(Arrays.asList((Object[])value));
        }
        return POJO_TYPE_MAPPING.get(value.getClass());
    }

    @Nullable
    public static DataType<?> getIntegralReturnType(DataType<?> argumentType) {
        switch (argumentType.id()) {
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                return INTEGER;
            }
            case 6: 
            case 10: {
                return LONG;
            }
        }
        return null;
    }

    private static DataType<?> valueFromList(List<Object> value) {
        DataType highest = UNDEFINED;
        for (Object o : value) {
            if (o == null) continue;
            DataType<Object> current = DataTypes.guessType(o);
            if (!current.equals(highest) && !DataTypes.safeConversionPossible(current, highest)) {
                throw new IllegalArgumentException("Mixed dataTypes inside a list are not supported. Found " + highest + " and " + current);
            }
            if (!current.precedes(highest)) continue;
            highest = current;
        }
        return new ArrayType<Object>(highest);
    }

    private static boolean safeConversionPossible(DataType<?> type1, DataType<?> type2) {
        DataType<?> target;
        DataType<?> source;
        if (type1.precedes(type2)) {
            source = type2;
            target = type1;
        } else {
            source = type1;
            target = type2;
        }
        if (source.id() == UNDEFINED.id()) {
            return true;
        }
        Set<DataType<?>> conversions = SAFE_CONVERSIONS.get(source.id());
        return conversions != null && conversions.contains(target);
    }

    public static DataType<?> ofName(String typeName) {
        DataType<?> dataType = DataTypes.ofNameOrNull(typeName);
        if (dataType == null) {
            throw new IllegalArgumentException("Cannot find data type: " + typeName);
        }
        return dataType;
    }

    public static DataType<?> of(String typeName, List<Integer> parameters) {
        DataType<?> dataType = DataTypes.ofNameOrNull(typeName);
        if (dataType == null) {
            throw new IllegalArgumentException("Cannot find data type: " + typeName);
        }
        if (!parameters.isEmpty()) {
            return switch (dataType.id()) {
                case 4 -> StringType.of(parameters);
                case 22 -> NumericType.of(parameters);
                default -> throw new IllegalArgumentException("The '" + typeName + "' type doesn't support type parameters.");
            };
        }
        return dataType;
    }

    @Nullable
    public static DataType<?> ofNameOrNull(String typeName) {
        return TYPES_BY_NAME_OR_ALIAS.get(typeName);
    }

    @Nullable
    public static String esMappingNameFrom(int typeId) {
        return TYPE_IDS_TO_MAPPINGS.get(typeId);
    }

    @Nullable
    public static DataType<?> ofMappingName(String name) {
        return MAPPING_NAMES_TO_TYPES.get(name);
    }

    public static boolean isPrimitive(DataType<?> type) {
        return PRIMITIVE_TYPE_IDS.contains(type.id());
    }

    public static boolean isNumericPrimitive(DataType<?> type) {
        return NUMERIC_PRIMITIVE_TYPE_IDS.contains(type.id());
    }

    public static void register(int id, Writeable.Reader<DataType<?>> dataType) {
        if (TYPE_REGISTRY.put(id, dataType) != null) {
            throw new IllegalArgumentException("Already got a dataType with id " + id);
        }
    }

    public static Streamer<?>[] getStreamers(Collection<? extends DataType<?>> dataTypes) {
        Streamer[] streamer = new Streamer[dataTypes.size()];
        int idx = 0;
        for (DataType<?> dataType : dataTypes) {
            streamer[idx] = dataType.streamer();
            ++idx;
        }
        return streamer;
    }

    public static boolean isSameType(DataType<?> left, DataType<?> right) {
        if (left.id() != right.id()) {
            return false;
        }
        if (DataTypes.isArray(left)) {
            return DataTypes.isSameType(((ArrayType)left).innerType(), ((ArrayType)right).innerType());
        }
        return true;
    }

    public static boolean isSameType(List<DataType<?>> left, List<DataType<?>> right) {
        if (left.size() != right.size()) {
            return false;
        }
        assert (left instanceof RandomAccess && right instanceof RandomAccess) : "data type lists should support RandomAccess for fast lookups";
        for (int i = 0; i < left.size(); ++i) {
            if (DataTypes.isSameType(left.get(i), right.get(i))) continue;
            return false;
        }
        return true;
    }

    public static DataType<?> tryFindNotNullType(List<DataType<?>> dataTypes) {
        return dataTypes.stream().filter(t -> t != UNDEFINED).findFirst().orElse(UNDEFINED);
    }

    public static DataType<?> fromId(Integer id) {
        return TYPES_BY_NAME_OR_ALIAS.values().stream().filter(x -> x.id() == id.intValue()).findFirst().orElse(UNDEFINED);
    }
}

