/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.data.RowN;
import io.crate.types.IntervalType;
import io.crate.types.TimeTZ;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderExtension;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.locationtech.spatial4j.shape.jts.JtsPoint;

public class DataTypeXContentExtension
implements XContentBuilderExtension {
    @Override
    public Map<Class<?>, XContentBuilder.Writer> getXContentWriters() {
        return Map.ofEntries(Map.entry(PointImpl.class, (b, v) -> {
            Point point = (Point)v;
            b.startArray();
            b.value(point.getX());
            b.value(point.getY());
            b.endArray();
        }), Map.entry(JtsPoint.class, (b, v) -> {
            Point point = (Point)v;
            b.startArray();
            b.value(point.getX());
            b.value(point.getY());
            b.endArray();
        }), Map.entry(Period.class, (b, v) -> {
            Period period = (Period)v;
            b.value(IntervalType.PERIOD_FORMATTER.print((ReadablePeriod)period));
        }), Map.entry(RowN.class, (b, v) -> {
            RowN row = (RowN)v;
            b.startArray();
            for (int i = 0; i < row.numColumns(); ++i) {
                b.value(row.get(i));
            }
            b.endArray();
        }), Map.entry(TimeTZ.class, (b, v) -> {
            TimeTZ timetz = (TimeTZ)v;
            b.startArray();
            b.value(timetz.getMicrosFromMidnight());
            b.value(timetz.getSecondsFromUTC());
            b.endArray();
        }));
    }

    @Override
    public Map<Class<?>, XContentBuilder.HumanReadableTransformer> getXContentHumanReadableTransformers() {
        return Map.of();
    }

    @Override
    public Map<Class<?>, Function<Object, Object>> getDateTransformers() {
        return Map.of();
    }
}

