/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public abstract class DataType<T>
implements Comparable<DataType<?>>,
Writeable,
Comparator<T> {
    public abstract int id();

    public abstract Precedence precedence();

    public abstract String getName();

    public abstract Streamer<T> streamer();

    public T implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        throw new UnsupportedOperationException("The cast operation is not supported.");
    }

    public T explicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.implicitCast(value);
    }

    public T valueForInsert(Object value) {
        return (T)value;
    }

    public abstract T sanitizeValue(Object var1);

    public TypeSignature getTypeSignature() {
        return new TypeSignature(this.getName());
    }

    public List<DataType<?>> getTypeParameters() {
        return Collections.emptyList();
    }

    public boolean precedes(DataType<?> other) {
        return this.precedence().ordinal() > other.precedence().ordinal();
    }

    public boolean isConvertableTo(DataType<?> other, boolean explicitCast) {
        if (this.equals(other)) {
            return true;
        }
        Set<Integer> possibleConversions = DataTypes.ALLOWED_CONVERSIONS.get(this.id());
        if (possibleConversions == null) {
            return false;
        }
        return possibleConversions.contains(other.id());
    }

    public int hashCode() {
        return this.id();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType that = (DataType)o;
        return this.id() == that.id();
    }

    @Override
    public int compareTo(DataType<?> o) {
        return Integer.compare(this.id(), o.id());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    public String toString() {
        return this.getName();
    }

    public static enum Precedence {
        NOT_SUPPORTED,
        UNDEFINED,
        LITERAL,
        STRING,
        BYTE,
        BOOLEAN,
        SHORT,
        TIMETZ,
        INTEGER,
        REGPROC,
        INTERVAL,
        TIMESTAMP_WITH_TIME_ZONE,
        TIMESTAMP,
        LONG,
        IP,
        FLOAT,
        DOUBLE,
        NUMERIC,
        ARRAY,
        SET,
        TABLE,
        GEO_POINT,
        OBJECT,
        UNCHECKED_OBJECT,
        GEO_SHAPE,
        CUSTOM;

    }
}

