/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.math.BigDecimal;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ByteType
extends DataType<Byte>
implements Streamer<Byte>,
FixedWidthType {
    public static final ByteType INSTANCE = new ByteType();
    public static final int ID = 2;

    private ByteType() {
    }

    @Override
    public int id() {
        return 2;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.BYTE;
    }

    @Override
    public String getName() {
        return "char";
    }

    @Override
    public Streamer<Byte> streamer() {
        return this;
    }

    @Override
    public Byte implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value instanceof BigDecimal) {
            try {
                return ((BigDecimal)value).byteValueExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("byte value out of range: " + value);
            }
        }
        if (value instanceof Number) {
            int val = ((Number)value).intValue();
            if (val < -128 || 127 < val) {
                throw new IllegalArgumentException("byte value out of range: " + val);
            }
            return (byte)val;
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Byte sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        return ((Number)value).byteValue();
    }

    @Override
    public int compare(Byte val1, Byte val2) {
        return Byte.compare(val1, val2);
    }

    @Override
    public Byte readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Byte.valueOf(in.readByte());
    }

    @Override
    public void writeValueTo(StreamOutput out, Byte v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeByte(v);
        }
    }

    @Override
    public int fixedSize() {
        return 16;
    }
}

