/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BooleanType
extends DataType<Boolean>
implements Streamer<Boolean>,
FixedWidthType {
    public static final int ID = 3;
    public static final BooleanType INSTANCE = new BooleanType();
    private static final Map<String, Boolean> BOOLEAN_MAP = Map.ofEntries(Map.entry("f", false), Map.entry("false", false), Map.entry("t", true), Map.entry("true", true));

    private BooleanType() {
    }

    @Override
    public int id() {
        return 3;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.BOOLEAN;
    }

    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    public Streamer<Boolean> streamer() {
        return this;
    }

    @Override
    public Boolean implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return this.booleanFromString((String)value);
        }
        if (value instanceof Number) {
            return this.booleanFromNumber((Number)value);
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Boolean sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.booleanFromNumber((Number)value);
    }

    private Boolean booleanFromString(String value) {
        String lowerValue = value.toLowerCase(Locale.ENGLISH);
        Boolean boolValue = BOOLEAN_MAP.get(lowerValue);
        if (boolValue == null) {
            throw new IllegalArgumentException("Can't convert \"" + value + "\" to boolean");
        }
        return boolValue;
    }

    private Boolean booleanFromNumber(Number value) {
        if (value.doubleValue() > 0.0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public int compare(Boolean val1, Boolean val2) {
        return Boolean.compare(val1, val2);
    }

    @Override
    public Boolean readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalBoolean();
    }

    @Override
    public void writeValueTo(StreamOutput out, Boolean v) throws IOException {
        out.writeOptionalBoolean(v);
    }

    @Override
    public int fixedSize() {
        return 8;
    }
}

