/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.protocols.postgres.parser.PgArrayParser;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ArrayType<T>
extends DataType<List<T>> {
    public static final String NAME = "array";
    public static final int ID = 100;
    private final DataType<T> innerType;
    private Streamer<List<T>> streamer;

    public ArrayType(DataType<T> innerType) {
        this.innerType = Objects.requireNonNull(innerType, "Inner type must not be null.");
    }

    public static DataType<?> makeArray(DataType<?> valueType, int numArrayDimensions) {
        DataType<?> arrayType = valueType;
        for (int i = 0; i < numArrayDimensions; ++i) {
            arrayType = new ArrayType(arrayType);
        }
        return arrayType;
    }

    @Override
    public TypeSignature getTypeSignature() {
        return new TypeSignature(NAME, List.of(this.innerType.getTypeSignature()));
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        return List.of(this.innerType);
    }

    @Override
    public Streamer<List<T>> streamer() {
        if (this.streamer == null) {
            this.streamer = new ArrayStreamer<T>(this.innerType);
        }
        return this.streamer;
    }

    public ArrayType(StreamInput in) throws IOException {
        this.innerType = DataTypes.fromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        DataTypes.toStream(this.innerType, out);
    }

    @Override
    public String getName() {
        return this.innerType.getName() + "_array";
    }

    @Override
    public int id() {
        return 100;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.ARRAY;
    }

    public final DataType<T> innerType() {
        return this.innerType;
    }

    @Override
    public List<T> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return ArrayType.convert(value, this.innerType::implicitCast);
    }

    @Override
    public List<T> explicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return ArrayType.convert(value, this.innerType::explicitCast);
    }

    @Override
    public List<T> sanitizeValue(Object value) {
        return ArrayType.convert(value, this.innerType::sanitizeValue);
    }

    public List<String> fromAnyArray(Object[] values) throws IllegalArgumentException {
        if (values == null) {
            return null;
        }
        ArrayList<String> array = new ArrayList<String>(values.length);
        for (Object value : values) {
            array.add(this.anyValueToString(value));
        }
        return array;
    }

    public List<String> fromAnyArray(List<?> values) throws IllegalArgumentException {
        if (values == null) {
            return null;
        }
        ArrayList<String> array = new ArrayList<String>(values.size());
        for (Object value : values) {
            array.add(this.anyValueToString(value));
        }
        return array;
    }

    private String anyValueToString(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Map) {
                return Strings.toString(XContentFactory.jsonBuilder().map((Map)value));
            }
            if (value instanceof Collection) {
                XContentBuilder array = XContentFactory.jsonBuilder().startArray();
                for (Object element : (Collection)value) {
                    array.value(element);
                }
                array.endArray();
                return Strings.toString(array);
            }
            return value.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    private static <T> List<T> convert(@Nullable Object value, Function<Object, T> innerType) {
        ArrayList<T> result;
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            result = new ArrayList<T>(values.size());
            for (Object o : values) {
                result.add(innerType.apply(o));
            }
        } else {
            if (value instanceof String) {
                return (List)PgArrayParser.parse(((String)value).getBytes(StandardCharsets.UTF_8), bytes -> innerType.apply(new String((byte[])bytes, StandardCharsets.UTF_8)));
            }
            Object[] values = (Object[])value;
            result = new ArrayList(values.length);
            for (Object o : values) {
                result.add(innerType.apply(o));
            }
        }
        return result;
    }

    @Override
    public int compareTo(DataType<?> o) {
        if (!(o instanceof ArrayType)) {
            return -1;
        }
        return this.innerType.compareTo(((ArrayType)o).innerType);
    }

    @Override
    public int compare(List<T> val1, List<T> val2) {
        if (val2 == null) {
            return 1;
        }
        if (val1 == null) {
            return -1;
        }
        if (val1.size() > val2.size()) {
            return 1;
        }
        if (val2.size() > val1.size()) {
            return -1;
        }
        for (int i = 0; i < val1.size(); ++i) {
            int cmp = Comparator.nullsFirst(this.innerType).compare(val1.get(i), val2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean isConvertableTo(DataType<?> other, boolean explicitCast) {
        return other.id() == 0 || other.id() == 13 || other instanceof ArrayType && this.innerType.isConvertableTo(((ArrayType)other).innerType(), explicitCast);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return Objects.equals(this.innerType, arrayType.innerType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.innerType.hashCode();
        return result;
    }

    public static DataType<?> unnest(DataType<?> dataType) {
        while (dataType instanceof ArrayType) {
            dataType = ((ArrayType)dataType).innerType();
        }
        return dataType;
    }

    static class ArrayStreamer<T>
    implements Streamer<List<T>> {
        private final DataType<T> innerType;

        ArrayStreamer(DataType<T> innerType) {
            this.innerType = innerType;
        }

        @Override
        public List<T> readValueFrom(StreamInput in) throws IOException {
            int size = in.readVInt();
            if (size == 0) {
                return null;
            }
            ArrayList<T> values = new ArrayList<T>(--size);
            for (int i = 0; i < size; ++i) {
                values.add(this.innerType.streamer().readValueFrom(in));
            }
            return values;
        }

        @Override
        public void writeValueTo(StreamOutput out, List<T> values) throws IOException {
            if (values == null) {
                out.writeVInt(0);
                return;
            }
            out.writeVInt(values.size() + 1);
            for (T value : values) {
                this.innerType.streamer().writeValueTo(out, value);
            }
        }
    }
}

