/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import io.crate.action.FutureActionListener;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.concurrent.CompletableFutures;
import io.crate.data.Row;
import io.crate.execution.ddl.AnalyzeRequest;
import io.crate.execution.support.MultiActionListener;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocSchemaInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.FetchSampleRequest;
import io.crate.statistics.FetchSampleResponse;
import io.crate.statistics.PublishTableStatsRequest;
import io.crate.statistics.ReservoirSampler;
import io.crate.statistics.Samples;
import io.crate.statistics.Stats;
import io.crate.statistics.TableStats;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportService;

@Singleton
public final class TransportAnalyzeAction {
    private static final String INVOKE_ANALYZE = "internal:crate:sql/analyze/invoke";
    private static final String FETCH_SAMPLES = "internal:crate:sql/analyze/fetch_samples";
    private static final String RECEIVE_TABLE_STATS = "internal:crate:sql/analyze/receive_stats";
    private static final int NUM_SAMPLES = 30000;
    private final TransportService transportService;
    private final Schemas schemas;
    private final ClusterService clusterService;

    @Inject
    public TransportAnalyzeAction(TransportService transportService, ReservoirSampler reservoirSampler, Schemas schemas, ClusterService clusterService, TableStats tableStats) {
        this.transportService = transportService;
        this.schemas = schemas;
        this.clusterService = clusterService;
        transportService.registerRequestHandler(INVOKE_ANALYZE, "same", AnalyzeRequest::new, new NodeActionRequestHandler(req -> this.fetchSamplesThenGenerateAndPublishStats()));
        transportService.registerRequestHandler(FETCH_SAMPLES, "search", FetchSampleRequest::new, new NodeActionRequestHandler(req -> CompletableFuture.completedFuture(new FetchSampleResponse(reservoirSampler.getSamples(req.relation(), req.columns(), req.maxSamples())))));
        transportService.registerRequestHandler(RECEIVE_TABLE_STATS, "same", PublishTableStatsRequest::new, new NodeActionRequestHandler(req -> {
            tableStats.updateTableStats(req.tableStats());
            return CompletableFuture.completedFuture(new AcknowledgedResponse(true));
        }));
    }

    public CompletableFuture<AcknowledgedResponse> fetchSamplesThenGenerateAndPublishStats() {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (SchemaInfo schema : this.schemas) {
            if (!(schema instanceof DocSchemaInfo)) continue;
            for (TableInfo table : schema.getTables()) {
                List<Reference> primitiveColumns = StreamSupport.stream(table.spliterator(), false).filter(x -> !x.column().isSystemColumn()).filter(x -> DataTypes.isPrimitive(x.valueType())).map(x -> table.getReadReference(x.column())).collect(Collectors.toList());
                futures.add(this.fetchSamples(table.ident(), primitiveColumns).thenApply(samples -> Map.entry(table.ident(), TransportAnalyzeAction.createTableStats(samples, primitiveColumns))));
            }
        }
        return CompletableFutures.allAsList(futures).thenCompose(entries -> this.publishTableStats(Map.ofEntries(entries.toArray(new Map.Entry[0]))));
    }

    private CompletableFuture<AcknowledgedResponse> publishTableStats(Map<RelationName, Stats> newTableStats) {
        List nodesOn41OrAfter = StreamSupport.stream(this.clusterService.state().nodes().spliterator(), false).filter(x -> x.getVersion().onOrAfter(Version.V_4_1_0)).collect(Collectors.toList());
        FutureActionListener<AcknowledgedResponse, AcknowledgedResponse> listener = new FutureActionListener<AcknowledgedResponse, AcknowledgedResponse>(x -> x);
        MultiActionListener multiListener = new MultiActionListener(nodesOn41OrAfter.size(), Collectors.reducing(new AcknowledgedResponse(true), (resp1, resp2) -> new AcknowledgedResponse(resp1.isAcknowledged() && resp2.isAcknowledged())), listener);
        ActionListenerResponseHandler<AcknowledgedResponse> responseHandler = new ActionListenerResponseHandler<AcknowledgedResponse>(multiListener, AcknowledgedResponse::new, "same");
        PublishTableStatsRequest request = new PublishTableStatsRequest(newTableStats);
        for (DiscoveryNode node : nodesOn41OrAfter) {
            this.transportService.sendRequest(node, RECEIVE_TABLE_STATS, request, responseHandler);
        }
        return listener;
    }

    @VisibleForTesting
    static Stats createTableStats(Samples samples, List<Reference> primitiveColumns) {
        List<Row> records = samples.records;
        ArrayList<Object> columnValues = new ArrayList<Object>(records.size());
        HashMap<ColumnIdent, ColumnStats> statsByColumn = new HashMap<ColumnIdent, ColumnStats>(primitiveColumns.size());
        for (int i = 0; i < primitiveColumns.size(); ++i) {
            Reference primitiveColumn = primitiveColumns.get(i);
            columnValues.clear();
            int nullCount = 0;
            for (Row record : records) {
                Object value = record.get(i);
                if (value == null) {
                    ++nullCount;
                    continue;
                }
                columnValues.add(value);
            }
            DataType<?> dataType = primitiveColumn.valueType();
            columnValues.sort(dataType::compare);
            ColumnStats columnStats = ColumnStats.fromSortedValues(columnValues, dataType, nullCount, samples.numTotalDocs);
            statsByColumn.put(primitiveColumn.column(), columnStats);
        }
        return new Stats(samples.numTotalDocs, samples.numTotalSizeInBytes, statsByColumn);
    }

    private CompletableFuture<Samples> fetchSamples(RelationName relationName, List<Reference> columns) {
        FutureActionListener<FetchSampleResponse, Samples> listener = new FutureActionListener<FetchSampleResponse, Samples>(FetchSampleResponse::samples);
        List nodesOn41OrAfter = StreamSupport.stream(this.clusterService.state().nodes().spliterator(), false).filter(x -> x.getVersion().onOrAfter(Version.V_4_1_0)).collect(Collectors.toList());
        MultiActionListener multiListener = new MultiActionListener(nodesOn41OrAfter.size(), Collectors.reducing(new FetchSampleResponse(Samples.EMPTY), (s1, s2) -> FetchSampleResponse.merge(30000, s1, s2)), listener);
        List<Streamer<?>> streamers = Arrays.asList(Symbols.streamerArray(columns));
        ActionListenerResponseHandler<FetchSampleResponse> responseHandler = new ActionListenerResponseHandler<FetchSampleResponse>(multiListener, in -> new FetchSampleResponse(streamers, in), "same");
        for (DiscoveryNode node : nodesOn41OrAfter) {
            this.transportService.sendRequest(node, FETCH_SAMPLES, new FetchSampleRequest(relationName, columns, 30000), responseHandler);
        }
        return listener;
    }
}

