/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.action.sql.BaseResultReceiver;
import io.crate.action.sql.SQLOperations;
import io.crate.action.sql.Session;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.unit.TimeValue;
import io.crate.data.Row;
import io.crate.settings.CrateSetting;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.Statement;
import io.crate.types.DataTypes;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class TableStatsService
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(TableStatsService.class);
    public static final CrateSetting<TimeValue> STATS_SERVICE_REFRESH_INTERVAL_SETTING = CrateSetting.of(Setting.timeSetting("stats.service.interval", TimeValue.timeValueHours(24L), Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING);
    static final String STMT = "ANALYZE";
    private static final Statement PARSED_STMT = SqlParser.createStatement("ANALYZE");
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Session session;
    @VisibleForTesting
    volatile TimeValue refreshInterval;
    @VisibleForTesting
    volatile Scheduler.ScheduledCancellable scheduledRefresh;

    @Inject
    public TableStatsService(Settings settings, ThreadPool threadPool, ClusterService clusterService, SQLOperations sqlOperations) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.refreshInterval = STATS_SERVICE_REFRESH_INTERVAL_SETTING.setting().get(settings);
        this.scheduledRefresh = this.scheduleNextRefresh(this.refreshInterval);
        this.session = sqlOperations.newSystemSession();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(STATS_SERVICE_REFRESH_INTERVAL_SETTING.setting(), this::setRefreshInterval);
    }

    @Override
    public void run() {
        this.updateStats();
    }

    public void updateStats() {
        if (this.clusterService.localNode() == null) {
            LOGGER.debug("Could not retrieve table stats. localNode is not fully available yet.");
            return;
        }
        if (!this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        try {
            BaseResultReceiver resultReceiver = new BaseResultReceiver();
            resultReceiver.completionFuture().whenComplete((res, err) -> {
                this.scheduledRefresh = this.scheduleNextRefresh(this.refreshInterval);
                if (err != null) {
                    LOGGER.error("Error running periodic ANALYZE", err);
                }
            });
            this.session.quickExec(STMT, stmt -> PARSED_STMT, resultReceiver, Row.EMPTY);
        }
        catch (Throwable t) {
            LOGGER.error("error retrieving table stats", t);
        }
    }

    @Nullable
    private Scheduler.ScheduledCancellable scheduleNextRefresh(TimeValue refreshInterval) {
        if (refreshInterval.millis() > 0L) {
            return this.threadPool.schedule(this, refreshInterval, "refresh");
        }
        return null;
    }

    private void setRefreshInterval(TimeValue newRefreshInterval) {
        if (this.scheduledRefresh != null) {
            this.scheduledRefresh.cancel();
            this.scheduledRefresh = null;
        }
        this.refreshInterval = newRefreshInterval;
        this.scheduledRefresh = this.scheduleNextRefresh(newRefreshInterval);
    }
}

