/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.ColumnStatsEntry;
import io.crate.statistics.Stats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TableStats {
    private volatile Map<RelationName, Stats> tableStats = new HashMap<RelationName, Stats>();

    public void updateTableStats(Map<RelationName, Stats> tableStats) {
        this.tableStats = tableStats;
    }

    public long numDocs(RelationName relationName) {
        return this.tableStats.getOrDefault((Object)relationName, (Stats)Stats.EMPTY).numDocs;
    }

    private long sizeInBytes(RelationName relationName) {
        return this.tableStats.getOrDefault((Object)relationName, (Stats)Stats.EMPTY).sizeInBytes;
    }

    public long estimatedSizePerRow(RelationName relationName) {
        return this.tableStats.getOrDefault(relationName, Stats.EMPTY).averageSizePerRowInBytes();
    }

    public Iterable<ColumnStatsEntry> statsEntries() {
        Set<Map.Entry<RelationName, Stats>> entries = this.tableStats.entrySet();
        return () -> entries.stream().flatMap(tableEntry -> {
            Stats stats = (Stats)tableEntry.getValue();
            return stats.statsByColumn().entrySet().stream().map(columnEntry -> new ColumnStatsEntry((RelationName)tableEntry.getKey(), (ColumnIdent)columnEntry.getKey(), (ColumnStats)columnEntry.getValue()));
        }).iterator();
    }

    public Stats getStats(RelationName relationName) {
        return this.tableStats.getOrDefault(relationName, Stats.EMPTY);
    }
}

