/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.statistics.ColumnStats;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

@VisibleForTesting
public class Stats
implements Writeable {
    public static final Stats EMPTY = new Stats();
    @VisibleForTesting
    final long numDocs;
    @VisibleForTesting
    final long sizeInBytes;
    private final Map<ColumnIdent, ColumnStats> statsByColumn;

    private Stats() {
        this.numDocs = -1L;
        this.sizeInBytes = -1L;
        this.statsByColumn = Map.of();
    }

    public Stats(long numDocs, long sizeInBytes, Map<ColumnIdent, ColumnStats> statsByColumn) {
        this.numDocs = numDocs;
        this.sizeInBytes = sizeInBytes;
        this.statsByColumn = statsByColumn;
    }

    public Stats(StreamInput in) throws IOException {
        this.numDocs = in.readLong();
        this.sizeInBytes = in.readLong();
        int numColumnStats = in.readVInt();
        this.statsByColumn = new HashMap<ColumnIdent, ColumnStats>();
        for (int i = 0; i < numColumnStats; ++i) {
            this.statsByColumn.put(new ColumnIdent(in), new ColumnStats(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.numDocs);
        out.writeLong(this.sizeInBytes);
        out.writeVInt(this.statsByColumn.size());
        for (Map.Entry<ColumnIdent, ColumnStats> entry : this.statsByColumn.entrySet()) {
            entry.getKey().writeTo(out);
            entry.getValue().writeTo(out);
        }
    }

    public long numDocs() {
        return this.numDocs;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long averageSizePerRowInBytes() {
        if (this.numDocs == -1L) {
            return -1L;
        }
        if (this.numDocs == 0L) {
            return 0L;
        }
        return this.sizeInBytes / this.numDocs;
    }

    public Map<ColumnIdent, ColumnStats> statsByColumn() {
        return this.statsByColumn;
    }

    public long estimateSizeForColumns(List<Symbol> toCollect) {
        long sum = 0L;
        for (int i = 0; i < toCollect.size(); ++i) {
            Symbol symbol = toCollect.get(i);
            ColumnStats columnStats = null;
            if (symbol instanceof Reference) {
                columnStats = this.statsByColumn.get(((Reference)symbol).column());
            } else if (symbol instanceof ScopedSymbol) {
                columnStats = this.statsByColumn.get(((ScopedSymbol)symbol).column());
            }
            if (columnStats == null) {
                if (symbol.valueType() instanceof FixedWidthType) {
                    sum += (long)((FixedWidthType)((Object)symbol.valueType())).fixedSize();
                    continue;
                }
                sum += 256L;
                continue;
            }
            sum = (long)((double)sum + columnStats.averageSizeInBytes());
        }
        return sum;
    }
}

