/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.RowN;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

class Samples
implements Writeable {
    static final Samples EMPTY = new Samples(List.of(), List.of(), 0L, 0L);
    private final List<Streamer> recordStreamer;
    final List<Row> records;
    final long numTotalDocs;
    final long numTotalSizeInBytes;

    Samples(List<Row> records, List<Streamer> recordStreamer, long numTotalDocs, long numTotalSizeInBytes) {
        this.records = records;
        this.recordStreamer = recordStreamer;
        this.numTotalDocs = numTotalDocs;
        this.numTotalSizeInBytes = numTotalSizeInBytes;
    }

    public Samples(List<Streamer> recordStreamer, StreamInput in) throws IOException {
        this.recordStreamer = recordStreamer;
        this.numTotalDocs = in.readLong();
        this.numTotalSizeInBytes = in.readLong();
        int numRecords = in.readVInt();
        this.records = new ArrayList<Row>(numRecords);
        for (int i = 0; i < numRecords; ++i) {
            Object[] cells = new Object[recordStreamer.size()];
            for (int c = 0; c < cells.length; ++c) {
                cells[c] = recordStreamer.get(c).readValueFrom(in);
            }
            this.records.add(new RowN(cells));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.numTotalDocs);
        out.writeLong(this.numTotalSizeInBytes);
        out.writeVInt(this.records.size());
        for (Row record : this.records) {
            assert (record.numColumns() == this.recordStreamer.size()) : "Number of columns in the row must match the number of streamers available";
            for (int i = 0; i < record.numColumns(); ++i) {
                this.recordStreamer.get(i).writeValueTo(out, record.get(i));
            }
        }
    }

    public static Samples merge(int maxSampleSize, Samples s1, Samples s2, Random random) {
        List<Row> newSamples = Samples.createNewSamples(maxSampleSize, s1, s2, random);
        return new Samples(newSamples, s1.recordStreamer.isEmpty() ? s2.recordStreamer : s1.recordStreamer, s1.numTotalDocs + s2.numTotalDocs, s1.numTotalSizeInBytes + s2.numTotalSizeInBytes);
    }

    private static List<Row> createNewSamples(int maxSampleSize, Samples s1, Samples s2, Random random) {
        if (s1.records.isEmpty()) {
            return s2.records;
        }
        if (s2.records.isEmpty()) {
            return s1.records;
        }
        if (s1.records.size() + s2.records.size() <= maxSampleSize) {
            return Lists2.concat(s1.records, s2.records);
        }
        int s1Size = s1.records.size();
        int s2Size = s2.records.size();
        ArrayList<Row> newSamples = new ArrayList<Row>(maxSampleSize);
        double p = (double)s2Size / (double)(s2Size + s1Size);
        for (int i = 0; i < maxSampleSize; ++i) {
            double j = random.nextDouble();
            if (j <= p) {
                newSamples.add(s1.records.get(random.nextInt(s1Size)));
                continue;
            }
            newSamples.add(s2.records.get(random.nextInt(s2Size)));
        }
        return newSamples;
    }
}

