/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import io.crate.breaker.BlockBasedRamAccounting;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.RowCellsAccountingWithEstimators;
import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.data.RowN;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.execution.engine.fetch.FetchId;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.FieldTypeLookup;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.statistics.Reservoir;
import io.crate.statistics.Samples;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public final class ReservoirSampler {
    private final ClusterService clusterService;
    private final NodeContext nodeCtx;
    private final Schemas schemas;
    private CircuitBreakerService circuitBreakerService;
    private final IndicesService indicesService;

    @Inject
    public ReservoirSampler(ClusterService clusterService, NodeContext nodeCtx, Schemas schemas, CircuitBreakerService circuitBreakerService, IndicesService indicesService) {
        this.clusterService = clusterService;
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
        this.circuitBreakerService = circuitBreakerService;
        this.indicesService = indicesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Samples getSamples(RelationName relationName, List<Reference> columns, int maxSamples) {
        Object table;
        try {
            table = this.schemas.getTableInfo(relationName);
        }
        catch (RelationUnknown e) {
            return Samples.EMPTY;
        }
        if (!(table instanceof DocTableInfo)) {
            return Samples.EMPTY;
        }
        DocTableInfo docTable = (DocTableInfo)table;
        Random random = Randomness.get();
        Metadata metadata = this.clusterService.state().metadata();
        CoordinatorTxnCtx coordinatorTxnCtx = CoordinatorTxnCtx.systemTransactionContext();
        List<Streamer> streamers = Arrays.asList(Symbols.streamerArray(columns));
        ArrayList<Engine.Searcher> searchersToRelease = new ArrayList<Engine.Searcher>();
        CircuitBreaker breaker = this.circuitBreakerService.getBreaker("query");
        BlockBasedRamAccounting ramAccounting = new BlockBasedRamAccounting(b -> breaker.addEstimateBytesAndMaybeBreak(b, "Reservoir-sampling"), 0x200000);
        try {
            Samples samples = this.getSamples(columns, maxSamples, docTable, random, metadata, coordinatorTxnCtx, streamers, searchersToRelease, ramAccounting);
            return samples;
        }
        finally {
            ramAccounting.close();
            for (Engine.Searcher searcher : searchersToRelease) {
                searcher.close();
            }
        }
    }

    private Samples getSamples(List<Reference> columns, int maxSamples, DocTableInfo docTable, Random random, Metadata metadata, CoordinatorTxnCtx coordinatorTxnCtx, List<Streamer> streamers, List<Engine.Searcher> searchersToRelease, RamAccounting ramAccounting) {
        ramAccounting.addBytes(DataTypes.LONG.fixedSize() * maxSamples);
        Reservoir<Long> fetchIdSamples = new Reservoir<Long>(maxSamples, random);
        ArrayList<DocIdToRow> docIdToRowsFunctionPerReader = new ArrayList<DocIdToRow>();
        long totalNumDocs = 0L;
        long totalSizeInBytes = 0L;
        for (String index : docTable.concreteOpenIndices()) {
            IndexService indexService;
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null || (indexService = this.indicesService.indexService(indexMetadata.getIndex())) == null) continue;
            MapperService mapperService = indexService.mapperService();
            FieldTypeLookup fieldTypeLookup = mapperService::fullName;
            InputFactory.Context<LuceneCollectorExpression<?>> ctx = new DocInputFactory(this.nodeCtx, new LuceneReferenceResolver(indexService.index().getName(), fieldTypeLookup, docTable.partitionedByColumns())).getCtx(coordinatorTxnCtx);
            ctx.add(columns);
            List<Input<?>> inputs = ctx.topLevelInputs();
            List<LuceneCollectorExpression<?>> expressions = ctx.expressions();
            CollectorContext collectorContext = new CollectorContext();
            for (LuceneCollectorExpression<?> expression : expressions) {
                expression.startCollect(collectorContext);
            }
            for (IndexShard indexShard : indexService) {
                if (!indexShard.routingEntry().primary()) continue;
                try {
                    Engine.Searcher searcher = indexShard.acquireSearcher("update-table-statistics");
                    searchersToRelease.add(searcher);
                    totalNumDocs += (long)searcher.getIndexReader().numDocs();
                    totalSizeInBytes += indexShard.storeStats().getSizeInBytes();
                    DocIdToRow docIdToRow = new DocIdToRow(searcher, inputs, expressions);
                    docIdToRowsFunctionPerReader.add(docIdToRow);
                    try {
                        ReservoirCollector collector = new ReservoirCollector(fetchIdSamples, searchersToRelease.size() - 1);
                        searcher.search((Query)new MatchAllDocsQuery(), collector);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                catch (AlreadyClosedException | IllegalIndexShardStateException throwable) {
                }
            }
        }
        RowCellsAccountingWithEstimators rowAccounting = new RowCellsAccountingWithEstimators(Symbols.typeView(columns), ramAccounting, 0);
        return new Samples(Lists2.map(fetchIdSamples.samples(), fetchId -> {
            int readerId = FetchId.decodeReaderId(fetchId);
            DocIdToRow docIdToRow = (DocIdToRow)docIdToRowsFunctionPerReader.get(readerId);
            Object[] row = docIdToRow.apply(FetchId.decodeDocId(fetchId));
            rowAccounting.accountForAndMaybeBreak(row);
            return new RowN(row);
        }), streamers, totalNumDocs, totalSizeInBytes);
    }

    static class DocIdToRow
    implements Function<Integer, Object[]> {
        private final Engine.Searcher searcher;
        private final List<Input<?>> inputs;
        private final List<? extends LuceneCollectorExpression<?>> expressions;

        DocIdToRow(Engine.Searcher searcher, List<Input<?>> inputs, List<? extends LuceneCollectorExpression<?>> expressions) {
            this.searcher = searcher;
            this.inputs = inputs;
            this.expressions = expressions;
        }

        @Override
        public Object[] apply(Integer docId) {
            List leaves = this.searcher.getIndexReader().leaves();
            int readerIndex = ReaderUtil.subIndex((int)docId, (List)leaves);
            LeafReaderContext leafContext = (LeafReaderContext)leaves.get(readerIndex);
            int subDoc = docId - leafContext.docBase;
            ReaderContext readerContext = new ReaderContext(leafContext);
            for (LuceneCollectorExpression<?> expression : this.expressions) {
                try {
                    expression.setNextReader(readerContext);
                    expression.setNextDocId(subDoc);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Object[] cells = new Object[this.inputs.size()];
            for (int i = 0; i < cells.length; ++i) {
                cells[i] = this.inputs.get(i).value();
            }
            return cells;
        }
    }

    private static class ReservoirCollector
    implements Collector {
        private final Reservoir<Long> reservoir;
        private int readerIdx;

        ReservoirCollector(Reservoir<Long> reservoir, int readerIdx) {
            this.reservoir = reservoir;
            this.readerIdx = readerIdx;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) {
            return new ReservoirLeafCollector(this.reservoir, this.readerIdx, context);
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    private static class ReservoirLeafCollector
    implements LeafCollector {
        private final Reservoir<Long> reservoir;
        private final int readerIdx;
        private final LeafReaderContext context;

        ReservoirLeafCollector(Reservoir<Long> reservoir, int readerIdx, LeafReaderContext context) {
            this.reservoir = reservoir;
            this.readerIdx = readerIdx;
            this.context = context;
        }

        public void setScorer(Scorable scorer) {
        }

        public void collect(int doc) {
            boolean shouldContinue = this.reservoir.update(FetchId.encode(this.readerIdx, doc + this.context.docBase));
            if (!shouldContinue) {
                throw new CollectionTerminatedException();
            }
        }
    }
}

