/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public final class Reservoir<T> {
    private final ArrayList<T> samples;
    private final int maxSamples;
    private final Random random;
    private int itemsSeen = 0;

    public Reservoir(int maxSamples, Random random) {
        this.samples = new ArrayList(maxSamples);
        this.maxSamples = maxSamples;
        this.random = random;
    }

    public boolean update(T item) {
        if (this.itemsSeen == Integer.MAX_VALUE) {
            return false;
        }
        ++this.itemsSeen;
        if (this.itemsSeen <= this.maxSamples) {
            this.samples.add(item);
        } else if (this.random.nextInt(this.itemsSeen) < this.maxSamples) {
            this.samples.set(this.random.nextInt(this.maxSamples), item);
        }
        return true;
    }

    public List<T> samples() {
        return Collections.unmodifiableList(this.samples);
    }
}

