/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class MostCommonValues {
    public static final MostCommonValues EMPTY = new MostCommonValues(new Object[0], new double[0]);
    static final int MCV_TARGET = 100;
    private final Object[] values;
    private final double[] frequencies;

    public static <T> MostCommonValues fromCandidates(double nullFraction, int numTracked, int distinctValues, double approxDistinct, List<T> samples, long numTotalRows, MVCCandidate[] candidates) {
        int numMcv = 100;
        if (numTracked == distinctValues && approxDistinct > 0.0 && numTracked <= numMcv) {
            numMcv = numTracked;
        } else {
            if (numMcv > numTracked) {
                numMcv = numTracked;
            }
            if (numMcv > 0) {
                int[] mcvCounts = new int[numMcv];
                for (int i = 0; i < numMcv; ++i) {
                    mcvCounts[i] = candidates[i].count;
                }
                numMcv = MostCommonValues.decodeHowManyCommonValuesToKeep(mcvCounts, numMcv, approxDistinct, nullFraction, samples.size(), numTotalRows);
            }
        }
        if (numMcv == 0) {
            return EMPTY;
        }
        Object[] values = new Object[numMcv];
        double[] frequencies = new double[numMcv];
        for (int i = 0; i < numMcv; ++i) {
            values[i] = samples.get(candidates[i].first);
            frequencies[i] = (double)candidates[i].count / (double)samples.size();
        }
        return new MostCommonValues(values, frequencies);
    }

    private static int decodeHowManyCommonValuesToKeep(int[] mcvCounts, int numMcv, double approxDistinct, double nullFraction, int numSampleRows, long numTotalRows) {
        assert (mcvCounts.length == numMcv) : "mcvCounts.length must be equal to numMcv";
        if ((long)numSampleRows == numTotalRows || numTotalRows <= 1L) {
            return numMcv;
        }
        int sumCount = 0;
        for (int i = 0; i < numMcv - 1; ++i) {
            sumCount += mcvCounts[i];
        }
        while (numMcv > 0) {
            double N;
            double K;
            double n;
            double variance;
            double stddev;
            double selectivity = 1.0 - (double)sumCount / (double)numSampleRows - nullFraction;
            selectivity = Math.max(0.0, Math.min(1.0, selectivity));
            double otherDistinct = approxDistinct - (double)(numMcv - 1);
            if (otherDistinct > 1.0) {
                selectivity /= otherDistinct;
            }
            if ((double)mcvCounts[numMcv - 1] > selectivity * (double)numSampleRows + 2.0 * (stddev = Math.sqrt(variance = (n = (double)numSampleRows) * (K = (N = (double)numTotalRows) * (double)mcvCounts[numMcv - 1] / n) * (N - K) * (N - n) / (N * N * (N - 1.0)))) + 0.5 || --numMcv == 0) break;
            sumCount -= mcvCounts[numMcv - 1];
        }
        return numMcv;
    }

    public MostCommonValues(Object[] values, double[] frequencies) {
        assert (values.length == frequencies.length) : "values and frequencies must have the same number of items";
        this.values = values;
        this.frequencies = frequencies;
    }

    public MostCommonValues(Streamer valueStreamer, StreamInput in) throws IOException {
        int numValues = in.readVInt();
        this.values = new Object[numValues];
        this.frequencies = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            this.values[i] = valueStreamer.readValueFrom(in);
            this.frequencies[i] = in.readDouble();
        }
    }

    public void writeTo(Streamer valueStreamer, StreamOutput out) throws IOException {
        out.writeVInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            valueStreamer.writeValueTo(out, this.values[i]);
            out.writeDouble(this.frequencies[i]);
        }
    }

    public Object[] values() {
        return this.values;
    }

    public double[] frequencies() {
        return this.frequencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MostCommonValues that = (MostCommonValues)o;
        if (!Arrays.equals(this.values, that.values)) {
            return false;
        }
        return Arrays.equals(this.frequencies, that.frequencies);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.values);
        result = 31 * result + Arrays.hashCode(this.frequencies);
        return result;
    }

    static class MVCCandidate {
        int first = 0;
        int count = 0;

        MVCCandidate() {
        }

        public String toString() {
            return "MVCCandidate{first=" + this.first + ", count=" + this.count + "}";
        }
    }
}

