/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public final class FetchSampleRequest
extends TransportRequest {
    private final RelationName relationName;
    private final List<Reference> columns;
    private final int maxSamples;

    public FetchSampleRequest(RelationName relationName, List<Reference> columns, int maxSamples) {
        this.relationName = relationName;
        this.columns = columns;
        this.maxSamples = maxSamples;
    }

    public FetchSampleRequest(StreamInput in) throws IOException {
        this.relationName = new RelationName(in);
        this.maxSamples = in.readVInt();
        int numColumns = in.readVInt();
        this.columns = new ArrayList<Reference>(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            this.columns.add((Reference)Reference.fromStream(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.relationName.writeTo(out);
        out.writeVInt(this.maxSamples);
        out.writeVInt(this.columns.size());
        for (Reference column : this.columns) {
            Reference.toStream(column, out);
        }
    }

    public RelationName relation() {
        return this.relationName;
    }

    public List<Reference> columns() {
        return this.columns;
    }

    public int maxSamples() {
        return this.maxSamples;
    }
}

