/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.statistics.MostCommonValues;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class ColumnStats<T>
implements Writeable {
    private final double nullFraction;
    private final double averageSizeInBytes;
    private final double approxDistinct;
    private final DataType<T> type;
    private final MostCommonValues mostCommonValues;
    private final List<T> histogram;

    public ColumnStats(double nullFraction, double averageSizeInBytes, double approxDistinct, DataType<T> type, MostCommonValues mostCommonValues, List<T> histogram) {
        this.nullFraction = nullFraction;
        this.averageSizeInBytes = averageSizeInBytes;
        this.approxDistinct = approxDistinct;
        this.type = type;
        this.mostCommonValues = mostCommonValues;
        this.histogram = histogram;
    }

    public ColumnStats(StreamInput in) throws IOException {
        this.type = DataTypes.fromStream(in);
        this.nullFraction = in.readDouble();
        this.averageSizeInBytes = in.readDouble();
        this.approxDistinct = in.readDouble();
        Streamer<T> streamer = this.type.streamer();
        this.mostCommonValues = new MostCommonValues(streamer, in);
        int numHistogramValues = in.readVInt();
        ArrayList<T> histogram = new ArrayList<T>(numHistogramValues);
        for (int i = 0; i < numHistogramValues; ++i) {
            histogram.add(streamer.readValueFrom(in));
        }
        this.histogram = histogram;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        DataTypes.toStream(this.type, out);
        out.writeDouble(this.nullFraction);
        out.writeDouble(this.averageSizeInBytes);
        out.writeDouble(this.approxDistinct);
        this.mostCommonValues.writeTo(this.type.streamer(), out);
        out.writeVInt(this.histogram.size());
        Streamer<T> streamer = this.type.streamer();
        for (T o : this.histogram) {
            streamer.writeValueTo(out, o);
        }
    }

    public double averageSizeInBytes() {
        return this.averageSizeInBytes;
    }

    public double nullFraction() {
        return this.nullFraction;
    }

    public double approxDistinct() {
        return this.approxDistinct;
    }

    public MostCommonValues mostCommonValues() {
        return this.mostCommonValues;
    }

    public List<T> histogram() {
        return this.histogram;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStats that = (ColumnStats)o;
        if (Double.compare(that.nullFraction, this.nullFraction) != 0) {
            return false;
        }
        if (Double.compare(that.averageSizeInBytes, this.averageSizeInBytes) != 0) {
            return false;
        }
        if (Double.compare(that.approxDistinct, this.approxDistinct) != 0) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.mostCommonValues.equals(that.mostCommonValues)) {
            return false;
        }
        return this.histogram.equals(that.histogram);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.nullFraction);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.averageSizeInBytes);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.approxDistinct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.mostCommonValues.hashCode();
        result = 31 * result + this.histogram.hashCode();
        return result;
    }

    public String toString() {
        return "ColumnStats{nullFraction=" + this.nullFraction + ", approxDistinct=" + this.approxDistinct + ", mcv=" + Arrays.toString(this.mostCommonValues.values()) + ", frequencies=" + Arrays.toString(this.mostCommonValues.frequencies()) + "}";
    }

    public static <T> ColumnStats<T> fromSortedValues(List<T> samples, DataType<T> type, int nullCount, long numTotalRows) {
        int notNullCount = samples.size();
        if (notNullCount == 0 && nullCount > 0) {
            double nullFraction = 1.0;
            int averageWidth = type instanceof FixedWidthType ? ((FixedWidthType)((Object)type)).fixedSize() : 0;
            long approxDistinct = 1L;
            return new ColumnStats<T>(nullFraction, averageWidth, approxDistinct, type, MostCommonValues.EMPTY, List.of());
        }
        boolean isVariableLength = !(type instanceof FixedWidthType);
        SizeEstimator<T> sizeEstimator = SizeEstimatorFactory.create(type);
        int mcvTarget = Math.min(100, samples.size());
        MostCommonValues.MVCCandidate[] mostCommonValueCandidates = ColumnStats.initMCVItems(mcvTarget);
        long totalSampleValueSizeInBytes = 0L;
        int numTracked = 0;
        int duplicates = 0;
        int distinctValues = 0;
        int numValuesWithDuplicates = 0;
        for (int i = 0; i < samples.size(); ++i) {
            boolean lastSample;
            T currentValue = samples.get(i);
            if (isVariableLength) {
                totalSampleValueSizeInBytes += sizeEstimator.estimateSize(currentValue);
            }
            if (i == 0) continue;
            T previousValue = samples.get(i - 1);
            ++duplicates;
            boolean sameAsPrevious = currentValue.equals(previousValue);
            boolean bl = lastSample = i == samples.size() - 1;
            if (sameAsPrevious && !lastSample) continue;
            ++distinctValues;
            if (duplicates > 1) {
                ++numValuesWithDuplicates;
                if (numTracked < mcvTarget || duplicates > mostCommonValueCandidates[numTracked - 1].count) {
                    if (numTracked < mcvTarget) {
                        ++numTracked;
                    }
                    ColumnStats.updateMostCommonValues(mostCommonValueCandidates, numTracked, duplicates, i);
                }
            }
            duplicates = 0;
        }
        double nullFraction = (double)nullCount / (double)(samples.size() + nullCount);
        double averageSizeInBytes = isVariableLength ? (double)totalSampleValueSizeInBytes / (double)notNullCount : (double)((FixedWidthType)((Object)type)).fixedSize();
        double approxDistinct = ColumnStats.approximateNumDistinct(nullFraction, distinctValues, numValuesWithDuplicates, samples.size(), numTotalRows);
        MostCommonValues mostCommonValues = MostCommonValues.fromCandidates(nullFraction, numTracked, distinctValues, approxDistinct, samples, numTotalRows, mostCommonValueCandidates);
        return new ColumnStats<T>(nullFraction, averageSizeInBytes, approxDistinct, type, mostCommonValues, ColumnStats.generateHistogram(100, ColumnStats.removeMCVs(samples, mostCommonValueCandidates)));
    }

    private static <T> List<T> removeMCVs(List<T> samples, MostCommonValues.MVCCandidate[] mostCommonValueCandidates) {
        Arrays.sort(mostCommonValueCandidates, Comparator.comparingInt(x -> x.first));
        ArrayList<T> prunedSamples = new ArrayList<T>();
        int i = 0;
        for (MostCommonValues.MVCCandidate mostCommonValueCandidate : mostCommonValueCandidates) {
            if (mostCommonValueCandidate.count == 0) continue;
            for (int j = i; j < mostCommonValueCandidate.first; ++j) {
                prunedSamples.add(samples.get(j));
            }
            i = mostCommonValueCandidate.first + mostCommonValueCandidate.count;
        }
        for (int j = i; j < samples.size(); ++j) {
            prunedSamples.add(samples.get(j));
        }
        return prunedSamples;
    }

    static <T> List<T> generateHistogram(int numBins, List<T> sortedValues) {
        int numHist = Math.min(numBins, sortedValues.size());
        if (numHist < 2) {
            return List.of();
        }
        ArrayList<T> histogram = new ArrayList<T>(numHist);
        int delta = (sortedValues.size() - 1) / (numHist - 1);
        int position = 0;
        for (int i = 0; i < numHist; ++i) {
            histogram.add(sortedValues.get(position));
            position += delta;
        }
        return histogram;
    }

    private static double approximateNumDistinct(double nullFraction, int distinctSamples, int numValuesWithDuplicates, int samplesWithoutNulls, long totalRows) {
        if (numValuesWithDuplicates == 0) {
            return (1.0 - nullFraction) * (double)totalRows;
        }
        if (numValuesWithDuplicates == distinctSamples) {
            return distinctSamples;
        }
        int f1 = distinctSamples - numValuesWithDuplicates;
        int d = f1 + numValuesWithDuplicates;
        double n = samplesWithoutNulls;
        double N = (double)totalRows * (1.0 - nullFraction);
        double approxDistinct = N > 0.0 ? n * (double)d / (n - (double)f1 + (double)f1 * n / N) : 0.0;
        if (approxDistinct < (double)d) {
            approxDistinct = d;
        }
        if (approxDistinct > N) {
            approxDistinct = N;
        }
        return Math.floor(approxDistinct + 0.5);
    }

    private static void updateMostCommonValues(MostCommonValues.MVCCandidate[] mostCommonValueCandidates, int numTracked, int duplicates, int i) {
        for (int j = numTracked - 1; j > 0 && duplicates > mostCommonValueCandidates[j - 1].count; --j) {
            mostCommonValueCandidates[j].count = mostCommonValueCandidates[j - 1].count;
            mostCommonValueCandidates[j].first = mostCommonValueCandidates[j - 1].first;
        }
        mostCommonValueCandidates[j].count = duplicates;
        mostCommonValueCandidates[j].first = i - duplicates;
    }

    private static MostCommonValues.MVCCandidate[] initMCVItems(int mcvTarget) {
        MostCommonValues.MVCCandidate[] trackedValues = new MostCommonValues.MVCCandidate[mcvTarget];
        for (int i = 0; i < trackedValues.length; ++i) {
            trackedValues[i] = new MostCommonValues.MVCCandidate();
        }
        return trackedValues;
    }
}

