/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists2;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QueryBody;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class Table<T>
extends QueryBody {
    private final QualifiedName name;
    private final boolean excludePartitions;
    private final List<Assignment<T>> partitionProperties;

    public Table(QualifiedName name) {
        this(name, true);
    }

    public Table(QualifiedName name, boolean excludePartitions) {
        this.name = name;
        this.excludePartitions = excludePartitions;
        this.partitionProperties = List.of();
    }

    public Table(QualifiedName name, List<Assignment<T>> partitionProperties) {
        this.name = name;
        this.excludePartitions = false;
        this.partitionProperties = partitionProperties;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean excludePartitions() {
        return this.excludePartitions;
    }

    public List<Assignment<T>> partitionProperties() {
        return this.partitionProperties;
    }

    public <U> Table<U> map(Function<? super T, ? extends U> mapper) {
        if (this.partitionProperties.isEmpty()) {
            return new Table<T>(this.name, this.excludePartitions);
        }
        return new Table<T>(this.name, Lists2.map(this.partitionProperties, x -> x.map(mapper)));
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTable(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.name, table.name) && Objects.equals(this.partitionProperties, table.partitionProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.partitionProperties);
    }

    @Override
    public String toString() {
        return "Table{only=" + this.excludePartitions + ", " + this.name + ", partitionProperties=" + this.partitionProperties + "}";
    }
}

