/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.WhenClause;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SimpleCaseExpression
extends Expression {
    private final Expression operand;
    private final List<WhenClause> whenClauses;
    private final Expression defaultValue;

    public SimpleCaseExpression(Expression operand, List<WhenClause> whenClauses, Expression defaultValue) {
        this.operand = Objects.requireNonNull(operand, "operand is null");
        this.whenClauses = Collections.unmodifiableList(whenClauses);
        this.defaultValue = defaultValue;
    }

    public Expression getOperand() {
        return this.operand;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleCaseExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCaseExpression that = (SimpleCaseExpression)o;
        return Objects.equals(this.operand, that.operand) && Objects.equals(this.whenClauses, that.whenClauses) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operand, this.whenClauses, this.defaultValue);
    }
}

