/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists2;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class SetTransactionStatement
extends Statement {
    private final List<TransactionMode> transactionModes;

    public SetTransactionStatement(List<TransactionMode> transactionModes) {
        this.transactionModes = transactionModes;
    }

    public List<TransactionMode> transactionModes() {
        return this.transactionModes;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.transactionModes);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SetTransactionStatement && ((SetTransactionStatement)obj).transactionModes.equals(this.transactionModes);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetTransaction(this, context);
    }

    @Override
    public String toString() {
        return "SET TRANSACTION " + Lists2.joinOn(", ", this.transactionModes, Object::toString);
    }

    public static class Deferrable
    implements TransactionMode {
        private final boolean not;

        public Deferrable(boolean not) {
            this.not = not;
        }

        public String toString() {
            return this.not ? "NOT DEFERRABLE" : "DEFERRABLE";
        }
    }

    public static enum ReadMode implements TransactionMode
    {
        READ_WRITE,
        READ_ONLY;

    }

    public static enum IsolationLevel implements TransactionMode
    {
        SERIALIZABLE,
        REPEATABLE_READ,
        READ_COMMITTED,
        READ_UNCOMMITTED;

    }

    public static interface TransactionMode {
    }
}

