/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.SelectItem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Select
extends Node {
    private final boolean distinct;
    private final List<SelectItem> selectItems;

    public Select(boolean distinct, List<SelectItem> selectItems) {
        this.distinct = distinct;
        this.selectItems = Collections.unmodifiableList(selectItems);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSelect(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        return this.distinct == select.distinct && Objects.equals(this.selectItems, select.selectItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distinct, this.selectItems);
    }

    @Override
    public String toString() {
        return "Select{distinct=" + this.distinct + ", selectItems=" + this.selectItems + "}";
    }
}

