/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QueryBody;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Query
extends Statement {
    private final QueryBody queryBody;
    private final List<SortItem> orderBy;
    private final Optional<Expression> limit;
    private final Optional<Expression> offset;

    public Query(QueryBody queryBody, List<SortItem> orderBy, Optional<Expression> limit, Optional<Expression> offset) {
        this.queryBody = Objects.requireNonNull(queryBody, "queryBody is null");
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Expression> getLimit() {
        return this.limit;
    }

    public Optional<Expression> getOffset() {
        return this.offset;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.queryBody, query.queryBody) && Objects.equals(this.orderBy, query.orderBy) && Objects.equals(this.limit, query.limit) && Objects.equals(this.offset, query.offset);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.queryBody, this.orderBy, this.limit, this.offset);
    }

    @Override
    public String toString() {
        return "Query{queryBody=" + this.queryBody + ", orderBy=" + this.orderBy + ", limit=" + this.limit + ", offset=" + this.offset + "}";
    }
}

