/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class PrivilegeStatement
extends Statement {
    protected final List<String> userNames;
    protected final List<String> privilegeTypes;
    private final List<QualifiedName> tableOrSchemaNames;
    private final String clazz;
    protected final boolean all;

    public PrivilegeStatement(List<String> userNames, String clazz, List<QualifiedName> tableOrSchemaNames) {
        this.userNames = userNames;
        this.privilegeTypes = Collections.emptyList();
        this.all = true;
        this.clazz = clazz;
        this.tableOrSchemaNames = tableOrSchemaNames;
    }

    public PrivilegeStatement(List<String> userNames, List<String> privilegeTypes, String clazz, List<QualifiedName> tableOrSchemaNames) {
        this.userNames = userNames;
        this.privilegeTypes = privilegeTypes;
        this.all = false;
        this.clazz = clazz;
        this.tableOrSchemaNames = tableOrSchemaNames;
    }

    public List<String> privileges() {
        return this.privilegeTypes;
    }

    public List<String> userNames() {
        return this.userNames;
    }

    public boolean all() {
        return this.all;
    }

    public List<QualifiedName> privilegeIdents() {
        return this.tableOrSchemaNames;
    }

    public String clazz() {
        return this.clazz;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeStatement that = (PrivilegeStatement)o;
        return this.all == that.all && Objects.equals(this.userNames, that.userNames) && Objects.equals(this.privilegeTypes, that.privilegeTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.userNames, this.privilegeTypes, this.all);
    }
}

