/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists2;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class PartitionedBy<T>
extends Node {
    private final List<T> columns;

    public PartitionedBy(List<T> columns) {
        this.columns = columns;
    }

    public List<T> columns() {
        return this.columns;
    }

    public <U> PartitionedBy<U> map(Function<? super T, ? extends U> mapper) {
        return new PartitionedBy<U>(Lists2.map(this.columns, mapper));
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.columns);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionedBy that = (PartitionedBy)o;
        return Objects.equals(this.columns, that.columns);
    }

    @Override
    public String toString() {
        return "PartitionedBy{columns=" + this.columns + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPartitionedBy(this, context);
    }
}

