/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists2;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class OptimizeStatement<T>
extends Statement {
    private final List<Table<T>> tables;
    private final GenericProperties<T> properties;

    public OptimizeStatement(List<Table<T>> tables, GenericProperties<T> properties) {
        this.tables = tables;
        this.properties = properties;
    }

    public List<Table<T>> tables() {
        return this.tables;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    public <U> OptimizeStatement<U> map(Function<? super T, ? extends U> mapper) {
        return new OptimizeStatement<U>(Lists2.map(this.tables, x -> x.map(mapper)), this.properties.map(mapper));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizeStatement that = (OptimizeStatement)o;
        return Objects.equals(this.tables, that.tables) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tables, this.properties);
    }

    @Override
    public String toString() {
        return "OptimizeStatement{tables=" + this.tables + ", properties=" + this.properties + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitOptimizeStatement(this, context);
    }
}

