/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists2;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.TableElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ObjectColumnType<T>
extends ColumnType<T> {
    private final Optional<ColumnPolicy> objectType;
    private final List<ColumnDefinition<T>> nestedColumns;

    public ObjectColumnType(@Nullable String objectType, List<ColumnDefinition<T>> nestedColumns) {
        super("object");
        this.objectType = objectType == null ? Optional.empty() : Optional.of(ColumnPolicy.of(objectType));
        this.nestedColumns = nestedColumns;
    }

    public Optional<ColumnPolicy> objectType() {
        return this.objectType;
    }

    public List<ColumnDefinition<T>> nestedColumns() {
        return this.nestedColumns;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitObjectColumnType(this, context);
    }

    @Override
    public <U> ObjectColumnType<U> map(Function<? super T, ? extends U> mapper) {
        String objectTypeString = null;
        if (this.objectType.isPresent()) {
            objectTypeString = this.objectType.get().lowerCaseName();
        }
        return new ObjectColumnType<T>(objectTypeString, Lists2.map(this.nestedColumns, x -> x.map(mapper)));
    }

    @Override
    public <U> ColumnType<U> mapExpressions(ColumnType<U> mappedType, Function<? super T, ? extends U> mapper) {
        ObjectColumnType mappedObjectType = (ObjectColumnType)mappedType;
        String objectTypeString = null;
        if (this.objectType.isPresent()) {
            objectTypeString = this.objectType.get().lowerCaseName();
        }
        ArrayList<ColumnDefinition<T>> nestedMappedColumns = new ArrayList<ColumnDefinition<T>>(this.nestedColumns.size());
        for (int i = 0; i < this.nestedColumns.size(); ++i) {
            ColumnDefinition columnDefinition = (ColumnDefinition)this.nestedColumns.get(i).mapExpressions((TableElement)mappedObjectType.nestedColumns.get(i), mapper);
            nestedMappedColumns.add(columnDefinition);
        }
        return new ObjectColumnType<T>(objectTypeString, nestedMappedColumns);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectColumnType that = (ObjectColumnType)o;
        if (!this.objectType.equals(that.objectType)) {
            return false;
        }
        return this.nestedColumns.equals(that.nestedColumns);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.objectType.hashCode();
        result = 31 * result + this.nestedColumns.hashCode();
        return result;
    }
}

