/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;

public class NegativeExpression
extends Expression {
    private final Expression value;

    public NegativeExpression(Expression value) {
        this.value = value;
    }

    public static Number negate(Object o) {
        if (o instanceof Long) {
            return -1L * (Long)o;
        }
        if (o instanceof Double) {
            return -1.0 * (Double)o;
        }
        throw new IllegalArgumentException("Can't negate " + o);
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNegativeExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NegativeExpression that = (NegativeExpression)o;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

