/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.BooleanLiteral;
import io.crate.sql.tree.DoubleLiteral;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.NullLiteral;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.StringLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Literal
extends Expression {
    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLiteral(this, context);
    }

    public static Literal fromObject(Object value) {
        Literal literal = null;
        if (value == null) {
            literal = NullLiteral.INSTANCE;
        } else if (value instanceof Number) {
            if (value instanceof Float || value instanceof Double) {
                literal = new DoubleLiteral(value.toString());
            } else if (value instanceof Short || value instanceof Integer) {
                literal = new IntegerLiteral(((Number)value).intValue());
            } else if (value instanceof Long) {
                literal = new LongLiteral((Long)value);
            }
        } else if (value instanceof Boolean) {
            literal = (Boolean)value != false ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL;
        } else if (value instanceof Object[]) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (Object o : (Object[])value) {
                expressions.add(Literal.fromObject(o));
            }
            literal = new ArrayLiteral(expressions);
        } else if (value instanceof Map) {
            HashMap<String, Expression> map = new HashMap<String, Expression>();
            Map valueMap = (Map)value;
            for (Map.Entry entry : valueMap.entrySet()) {
                map.put((String)entry.getKey(), Literal.fromObject(entry.getValue()));
            }
            literal = new ObjectLiteral(map);
        } else {
            literal = new StringLiteral(value.toString());
        }
        return literal;
    }
}

