/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.ComparisonExpression;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.LogicalBinaryExpression;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class JoinUsing
extends JoinCriteria {
    private final List<String> columns;

    private static QualifiedName extendQualifiedName(QualifiedName name, String ext) {
        ArrayList<String> parts = new ArrayList<String>(name.getParts().size() + 1);
        parts.addAll(name.getParts());
        parts.add(ext);
        return new QualifiedName(parts);
    }

    public static Expression toExpression(QualifiedName left, QualifiedName right, List<String> columns) {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("columns must not be empty");
        }
        List comp = columns.stream().map(col -> new ComparisonExpression(ComparisonExpression.Type.EQUAL, new QualifiedNameReference(JoinUsing.extendQualifiedName(left, col)), new QualifiedNameReference(JoinUsing.extendQualifiedName(right, col)))).collect(Collectors.toList());
        if (1 == comp.size()) {
            return (Expression)comp.get(0);
        }
        LogicalBinaryExpression expr = null;
        for (int i = comp.size() - 2; i >= 0; --i) {
            expr = null == expr ? new LogicalBinaryExpression(LogicalBinaryExpression.Type.AND, (Expression)comp.get(i), (Expression)comp.get(i + 1)) : new LogicalBinaryExpression(LogicalBinaryExpression.Type.AND, (Expression)comp.get(i), expr);
        }
        return expr;
    }

    public JoinUsing(List<String> columns) {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("columns must not be empty");
        }
        this.columns = List.copyOf(columns);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinUsing joinUsing = (JoinUsing)o;
        return Objects.equals(this.columns, joinUsing.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns);
    }

    @Override
    public String toString() {
        return "JoinUsing{columns=" + this.columns + "}";
    }
}

