/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.SelectItem;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Insert<T>
extends Statement {
    private final Table<T> table;
    private final DuplicateKeyContext<T> duplicateKeyContext;
    private final List<String> columns;
    private final Query insertSource;
    private final List<SelectItem> returning;

    public Insert(Table<T> table, Query insertSource, List<String> columns, List<SelectItem> returning, DuplicateKeyContext<T> duplicateKeyContext) {
        this.table = table;
        this.columns = columns;
        this.insertSource = insertSource;
        this.duplicateKeyContext = duplicateKeyContext;
        this.returning = returning;
    }

    public Table<T> table() {
        return this.table;
    }

    public List<String> columns() {
        return this.columns;
    }

    public Query insertSource() {
        return this.insertSource;
    }

    public DuplicateKeyContext<T> duplicateKeyContext() {
        return this.duplicateKeyContext;
    }

    public List<SelectItem> returningClause() {
        return this.returning;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Insert insert = (Insert)o;
        return Objects.equals(this.table, insert.table) && Objects.equals(this.duplicateKeyContext, insert.duplicateKeyContext) && Objects.equals(this.columns, insert.columns) && Objects.equals(this.insertSource, insert.insertSource) && Objects.equals(this.returning, insert.returning);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.duplicateKeyContext, this.columns, this.insertSource, this.returning);
    }

    @Override
    public String toString() {
        return "Insert{table=" + this.table + ", duplicateKeyContext=" + this.duplicateKeyContext + ", columns=" + this.columns + ", insertSource=" + this.insertSource + ", returning=" + this.returning + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsert(this, context);
    }

    public static class DuplicateKeyContext<T> {
        private static final DuplicateKeyContext<?> NONE = new DuplicateKeyContext(Type.NONE, Collections.emptyList(), Collections.emptyList());
        private final Type type;
        private final List<Assignment<T>> onDuplicateKeyAssignments;
        private final List<T> constraintColumns;

        public static <T> DuplicateKeyContext<T> none() {
            return NONE;
        }

        public DuplicateKeyContext(Type type, List<Assignment<T>> onDuplicateKeyAssignments, List<T> constraintColumns) {
            this.type = type;
            this.onDuplicateKeyAssignments = onDuplicateKeyAssignments;
            this.constraintColumns = constraintColumns;
        }

        public Type getType() {
            return this.type;
        }

        public List<Assignment<T>> getAssignments() {
            return this.onDuplicateKeyAssignments;
        }

        public List<T> getConstraintColumns() {
            return this.constraintColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DuplicateKeyContext that = (DuplicateKeyContext)o;
            return this.type == that.type && Objects.equals(this.onDuplicateKeyAssignments, that.onDuplicateKeyAssignments) && Objects.equals(this.constraintColumns, that.constraintColumns);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.onDuplicateKeyAssignments, this.constraintColumns});
        }

        public String toString() {
            return "DuplicateKeyContext{type=" + this.type + ", onDuplicateKeyAssignments=" + this.onDuplicateKeyAssignments + ", constraintColumns=" + this.constraintColumns + "}";
        }

        public static enum Type {
            ON_CONFLICT_DO_UPDATE_SET,
            ON_CONFLICT_DO_NOTHING,
            NONE;

        }
    }
}

