/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.GenericProperties;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class IndexColumnConstraint<T>
extends ColumnConstraint<T> {
    private static final IndexColumnConstraint<?> OFF = new IndexColumnConstraint("OFF", GenericProperties.empty());
    private final String indexMethod;
    private final GenericProperties<T> properties;

    public static <T> IndexColumnConstraint<T> off() {
        return OFF;
    }

    public IndexColumnConstraint(String indexMethod, GenericProperties<T> properties) {
        this.indexMethod = indexMethod;
        this.properties = properties;
    }

    public String indexMethod() {
        return this.indexMethod;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexColumnConstraint that = (IndexColumnConstraint)o;
        return Objects.equals(this.indexMethod, that.indexMethod) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexMethod, this.properties);
    }

    @Override
    public String toString() {
        return "IndexColumnConstraint{method='" + this.indexMethod + "', properties=" + this.properties + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIndexColumnConstraint(this, context);
    }

    @Override
    public <U> ColumnConstraint<U> map(Function<? super T, ? extends U> mapper) {
        return new IndexColumnConstraint<U>(this.indexMethod, this.properties.map(mapper));
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        this.properties.properties().values().forEach(consumer);
    }
}

