/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AnalyzerElement;
import io.crate.sql.tree.AstVisitor;
import java.util.Objects;

public class GenericProperty<T>
extends AnalyzerElement {
    private final String key;
    private final T value;

    public GenericProperty(String key, T value) {
        this.key = key;
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public T value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericProperty that = (GenericProperty)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public String toString() {
        return "GenericProperty{key='" + this.key + "', value=" + this.value + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericProperty(this, context);
    }
}

