/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperty;
import io.crate.sql.tree.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class GenericProperties<T>
extends Node {
    private static final GenericProperties<?> EMPTY = new GenericProperties(Map.of());
    private final Map<String, T> properties;

    public static <T> GenericProperties<T> empty() {
        return EMPTY;
    }

    public GenericProperties() {
        this.properties = new HashMap<String, T>();
    }

    public GenericProperties(Map<String, T> map) {
        this.properties = map;
    }

    public Map<String, T> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public T get(String key) {
        return this.properties.get(key);
    }

    public void add(GenericProperty<T> property) {
        this.properties.put(property.key(), property.value());
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public <U> GenericProperties<U> map(Function<? super T, ? extends U> mapper) {
        if (this.isEmpty()) {
            return GenericProperties.empty();
        }
        HashMap mappedProperties = new HashMap(this.properties.size());
        this.properties.forEach((key, value) -> mappedProperties.put(key, mapper.apply(value)));
        return new GenericProperties(mappedProperties);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericProperties that = (GenericProperties)o;
        return Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.properties);
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericProperties(this, context);
    }

    public int size() {
        return this.properties.size();
    }

    public Set<String> keys() {
        return this.properties.keySet();
    }
}

