/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import java.util.Objects;

public class Explain
extends Statement {
    private final Statement statement;
    private final boolean analyze;

    public Explain(Statement statement, boolean analyze) {
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.analyze = analyze;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean isAnalyze() {
        return this.analyze;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Explain explain = (Explain)o;
        return this.analyze == explain.analyze && Objects.equals(this.statement, explain.statement);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.analyze);
    }

    @Override
    public String toString() {
        return "Explain{statement=" + this.statement + ", analyze=" + this.analyze + "}";
    }
}

