/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.FunctionArgument;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class CreateFunction<T>
extends Statement {
    private final QualifiedName name;
    private final boolean replace;
    private final List<FunctionArgument> arguments;
    private final ColumnType<T> returnType;
    private final T language;
    private final T definition;

    public CreateFunction(QualifiedName name, boolean replace, List<FunctionArgument> arguments, ColumnType<T> returnType, T language, T definition) {
        this.name = name;
        this.replace = replace;
        this.arguments = arguments;
        this.returnType = returnType;
        this.language = language;
        this.definition = definition;
    }

    public QualifiedName name() {
        return this.name;
    }

    public boolean replace() {
        return this.replace;
    }

    public List<FunctionArgument> arguments() {
        return this.arguments;
    }

    public ColumnType<T> returnType() {
        return this.returnType;
    }

    public T language() {
        return this.language;
    }

    public T definition() {
        return this.definition;
    }

    public <U> CreateFunction<U> map(Function<? super T, ? extends U> mapper) {
        return new CreateFunction<U>(this.name, this.replace, this.arguments, this.returnType.map(mapper), mapper.apply(this.language), mapper.apply(this.definition));
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateFunction(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFunction that = (CreateFunction)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.replace, that.replace) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.language, that.language);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.replace, this.arguments, this.returnType, this.language);
    }

    @Override
    public String toString() {
        return "CreateFunction{name=" + this.name + ", replace=" + this.replace + ", arguments=" + this.arguments + ", returnType=" + this.returnType + ", language=" + this.language + ", definition=" + this.definition + "}";
    }
}

