/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CopyTo<T>
extends Statement {
    private final Table<T> table;
    private final List<T> columns;
    private final Optional<T> whereClause;
    private final boolean directoryUri;
    private final T targetUri;
    private final GenericProperties<T> properties;

    public CopyTo(Table<T> table, List<T> columns, Optional<T> whereClause, boolean directoryUri, T targetUri, GenericProperties<T> properties) {
        this.table = table;
        this.directoryUri = directoryUri;
        this.targetUri = targetUri;
        this.properties = properties;
        this.columns = columns;
        this.whereClause = whereClause;
    }

    public Table<T> table() {
        return this.table;
    }

    public boolean directoryUri() {
        return this.directoryUri;
    }

    public T targetUri() {
        return this.targetUri;
    }

    public List<T> columns() {
        return this.columns;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    public Optional<T> whereClause() {
        return this.whereClause;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyTo copyTo = (CopyTo)o;
        return this.directoryUri == copyTo.directoryUri && Objects.equals(this.table, copyTo.table) && Objects.equals(this.targetUri, copyTo.targetUri) && Objects.equals(this.properties, copyTo.properties) && Objects.equals(this.columns, copyTo.columns) && Objects.equals(this.whereClause, copyTo.whereClause);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.directoryUri, this.targetUri, this.properties, this.columns, this.whereClause);
    }

    @Override
    public String toString() {
        return "CopyTo{table=" + this.table + ", directoryUri=" + this.directoryUri + ", targetUri=" + this.targetUri + ", properties=" + this.properties + ", columns=" + this.columns + ", whereClause=" + this.whereClause + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCopyTo(this, context);
    }
}

