/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class ColumnType<T>
extends Expression {
    private final String name;
    private final List<Integer> parameters;

    public ColumnType(String name) {
        this(name, List.of());
    }

    public ColumnType(String name, List<Integer> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public String name() {
        return this.name;
    }

    public List<Integer> parameters() {
        return this.parameters;
    }

    public boolean parametrized() {
        return !this.parameters.isEmpty();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumnType(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnType that = (ColumnType)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameters);
    }

    public <U> ColumnType<U> map(Function<? super T, ? extends U> mapper) {
        return new ColumnType<T>(this.name, this.parameters);
    }

    public <U> ColumnType<U> mapExpressions(ColumnType<U> mappedType, Function<? super T, ? extends U> mapper) {
        return mappedType;
    }
}

