/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists2;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.TableElement;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ColumnDefinition<T>
extends TableElement<T> {
    private final String ident;
    @Nullable
    private final T defaultExpression;
    @Nullable
    private final T generatedExpression;
    private final boolean generated;
    @Nullable
    private final ColumnType<T> type;
    private final List<ColumnConstraint<T>> constraints;

    public ColumnDefinition(String ident, @Nullable T defaultExpression, @Nullable T generatedExpression, @Nullable ColumnType<T> type, List<ColumnConstraint<T>> constraints) {
        this(ident, defaultExpression, generatedExpression, type, constraints, true, generatedExpression != null);
    }

    public ColumnDefinition(String ident, @Nullable T defaultExpression, @Nullable T generatedExpression, @Nullable ColumnType<T> type, List<ColumnConstraint<T>> constraints, boolean validate, boolean generated) {
        this.ident = ident;
        this.defaultExpression = defaultExpression;
        this.generatedExpression = generatedExpression;
        this.generated = generated;
        this.type = type;
        this.constraints = constraints;
        if (validate) {
            this.validateColumnDefinition();
        }
    }

    private void validateColumnDefinition() {
        if (this.type == null && this.generatedExpression == null) {
            throw new IllegalArgumentException("Column [" + this.ident + "]: data type needs to be provided or column should be defined as a generated expression");
        }
        if (this.defaultExpression != null && this.generatedExpression != null) {
            throw new IllegalArgumentException("Column [" + this.ident + "]: the default and generated expressions are mutually exclusive");
        }
    }

    public String ident() {
        return this.ident;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    @Nullable
    public T generatedExpression() {
        return this.generatedExpression;
    }

    @Nullable
    public T defaultExpression() {
        return this.defaultExpression;
    }

    @Nullable
    public ColumnType<T> type() {
        return this.type;
    }

    public List<ColumnConstraint<T>> constraints() {
        return this.constraints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        return this.generated == that.generated && Objects.equals(this.ident, that.ident) && Objects.equals(this.defaultExpression, that.defaultExpression) && Objects.equals(this.generatedExpression, that.generatedExpression) && Objects.equals(this.type, that.type) && Objects.equals(this.constraints, that.constraints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ident, this.defaultExpression, this.generatedExpression, this.generated, this.type, this.constraints);
    }

    @Override
    public String toString() {
        return "ColumnDefinition{ident='" + this.ident + "', defaultExpression=" + this.defaultExpression + ", generatedExpression=" + this.generatedExpression + ", generated=" + this.generated + ", type=" + this.type + ", constraints=" + this.constraints + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumnDefinition(this, context);
    }

    @Override
    public <U> ColumnDefinition<U> map(Function<? super T, ? extends U> mapper) {
        return new ColumnDefinition<U>(this.ident, null, null, this.type == null ? null : this.type.map(mapper), Lists2.map(this.constraints, x -> x.map(mapper)), false, this.generatedExpression != null);
    }

    @Override
    public <U> TableElement<U> mapExpressions(TableElement<U> mappedElement, Function<? super T, ? extends U> mapper) {
        ColumnDefinition mappedDefinition = (ColumnDefinition)mappedElement;
        return new ColumnDefinition<Object>(mappedDefinition.ident, (this.defaultExpression == null ? null : (T)mapper.apply((T)this.defaultExpression)), (this.generatedExpression == null ? null : (T)mapper.apply((T)this.generatedExpression)), (ColumnType<Object>)(this.type == null ? null : this.type.mapExpressions(mappedDefinition.type, mapper)), (List<ColumnConstraint<Object>>)mappedDefinition.constraints);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        if (this.defaultExpression != null) {
            consumer.accept(this.defaultExpression);
        }
        if (this.generatedExpression != null) {
            consumer.accept(this.generatedExpression);
        }
        for (ColumnConstraint<T> constraint : this.constraints) {
            constraint.visit(consumer);
        }
    }
}

