/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.TableElement;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class CheckConstraint<T>
extends TableElement<T> {
    @Nullable
    private final String name;
    @Nullable
    private final String columnName;
    private final T expression;
    private final String expressionStr;

    public CheckConstraint(@Nullable String name, @Nullable String columnName, T expression, String expressionStr) {
        this.name = name;
        this.columnName = columnName;
        this.expression = expression;
        this.expressionStr = expressionStr;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public String columnName() {
        return this.columnName;
    }

    public T expression() {
        return this.expression;
    }

    public String expressionStr() {
        return this.expressionStr;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.columnName, this.expression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CheckConstraint)) {
            return false;
        }
        CheckConstraint that = (CheckConstraint)o;
        return Objects.equals(this.expression, that.expression) && Objects.equals(this.name, that.name) && Objects.equals(this.columnName, that.columnName);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCheckConstraint(this, context);
    }

    @Override
    public <U> TableElement<U> map(Function<? super T, ? extends U> mapper) {
        return new CheckConstraint<U>(this.name, this.columnName, mapper.apply(this.expression), this.expressionStr);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        consumer.accept(this.expression);
    }

    @Override
    public String toString() {
        return "CheckConstraint{name='" + this.name + "', columnName='" + this.columnName + "', expression=" + this.expression + "}";
    }
}

