/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnConstraint;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class CheckColumnConstraint<T>
extends ColumnConstraint<T> {
    @Nullable
    private final String name;
    private final String columnName;
    private final T expression;
    private final String expressionStr;

    public CheckColumnConstraint(@Nullable String name, String columnName, T expression, String expressionStr) {
        this.name = name;
        this.columnName = columnName;
        this.expression = expression;
        this.expressionStr = expressionStr;
    }

    public String columnName() {
        return this.columnName;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public T expression() {
        return this.expression;
    }

    public String expressionStr() {
        return this.expressionStr;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.columnName, this.expression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof CheckColumnConstraint)) {
            return false;
        }
        CheckColumnConstraint that = (CheckColumnConstraint)o;
        return Objects.equals(this.expression, that.expression) && Objects.equals(this.columnName, that.columnName) && Objects.equals(this.name, that.name);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCheckColumnConstraint(this, context);
    }

    @Override
    public <U> ColumnConstraint<U> map(Function<? super T, ? extends U> mapper) {
        return new CheckColumnConstraint<U>(this.name, this.columnName, mapper.apply(this.expression), this.expressionStr);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        consumer.accept(this.expression);
    }

    @Override
    public String toString() {
        return "CheckColumnConstraint{name='" + this.name + "', columnName='" + this.columnName + "', expression=" + this.expression + "}";
    }
}

