/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import java.util.Objects;

public class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    public BetweenPredicate(Expression value, Expression min, Expression max) {
        this.value = Objects.requireNonNull(value, "value is null");
        this.min = Objects.requireNonNull(min, "min is null");
        this.max = Objects.requireNonNull(max, "max is null");
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getMin() {
        return this.min;
    }

    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.min, this.max);
    }
}

