/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists2;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.TableElement;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class AddColumnDefinition<T>
extends TableElement<T> {
    private final T name;
    @Nullable
    private final T generatedExpression;
    private final boolean generated;
    @Nullable
    private final ColumnType<T> type;
    private final List<ColumnConstraint<T>> constraints;

    public AddColumnDefinition(T name, @Nullable T generatedExpression, @Nullable ColumnType<T> type, List<ColumnConstraint<T>> constraints) {
        this(name, generatedExpression, type, constraints, true, generatedExpression != null);
    }

    public AddColumnDefinition(T name, @Nullable T generatedExpression, @Nullable ColumnType<T> type, List<ColumnConstraint<T>> constraints, boolean validate, boolean generated) {
        this.name = name;
        this.generatedExpression = generatedExpression;
        this.generated = generated;
        this.type = type;
        this.constraints = constraints;
        if (validate) {
            this.validateColumnDefinition();
        }
    }

    private void validateColumnDefinition() {
        if (this.type == null && this.generatedExpression == null) {
            throw new IllegalArgumentException("Column [" + this.name + "]: data type needs to be provided or column should be defined as a generated expression");
        }
    }

    public T name() {
        return this.name;
    }

    @Nullable
    public T generatedExpression() {
        return this.generatedExpression;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    @Nullable
    public ColumnType<T> type() {
        return this.type;
    }

    public List<ColumnConstraint<T>> constraints() {
        return this.constraints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddColumnDefinition that = (AddColumnDefinition)o;
        return this.generated == that.generated && Objects.equals(this.name, that.name) && Objects.equals(this.generatedExpression, that.generatedExpression) && Objects.equals(this.type, that.type) && Objects.equals(this.constraints, that.constraints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.generatedExpression, this.generated, this.type, this.constraints);
    }

    @Override
    public String toString() {
        return "AddColumnDefinition{name=" + this.name + ", generatedExpression=" + this.generatedExpression + ", generated=" + this.generated + ", type=" + this.type + ", constraints=" + this.constraints + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddColumnDefinition(this, context);
    }

    @Override
    public <U> AddColumnDefinition<U> map(Function<? super T, ? extends U> mapper) {
        return new AddColumnDefinition<U>(mapper.apply(this.name), null, this.type == null ? null : this.type.map(mapper), Lists2.map(this.constraints, x -> x.map(mapper)), false, this.generatedExpression != null);
    }

    @Override
    public <U> TableElement<U> mapExpressions(TableElement<U> mappedElement, Function<? super T, ? extends U> mapper) {
        AddColumnDefinition mappedAddDefinition = (AddColumnDefinition)mappedElement;
        return new AddColumnDefinition<Object>(mappedAddDefinition.name, (this.generatedExpression == null ? null : (T)mapper.apply((T)this.generatedExpression)), (ColumnType<Object>)(this.type == null ? null : this.type.mapExpressions(mappedAddDefinition.type, mapper)), (List<ColumnConstraint<Object>>)mappedAddDefinition.constraints);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        consumer.accept(this.name);
        consumer.accept(this.generatedExpression);
        for (ColumnConstraint<T> constraint : this.constraints) {
            constraint.visit(consumer);
        }
    }
}

