/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.parser;

import io.crate.common.collections.Lists2;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.parser.antlr.v4.SqlBaseBaseVisitor;
import io.crate.sql.parser.antlr.v4.SqlBaseParser;
import io.crate.sql.tree.AddColumnDefinition;
import io.crate.sql.tree.AliasedRelation;
import io.crate.sql.tree.AllColumns;
import io.crate.sql.tree.AlterBlobTable;
import io.crate.sql.tree.AlterClusterRerouteRetryFailed;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.AlterTableAddColumn;
import io.crate.sql.tree.AlterTableOpenClose;
import io.crate.sql.tree.AlterTableRename;
import io.crate.sql.tree.AlterTableReroute;
import io.crate.sql.tree.AlterUser;
import io.crate.sql.tree.AnalyzeStatement;
import io.crate.sql.tree.AnalyzerElement;
import io.crate.sql.tree.ArithmeticExpression;
import io.crate.sql.tree.ArrayComparison;
import io.crate.sql.tree.ArrayComparisonExpression;
import io.crate.sql.tree.ArrayLikePredicate;
import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.ArraySubQueryExpression;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.BeginStatement;
import io.crate.sql.tree.BetweenPredicate;
import io.crate.sql.tree.BooleanLiteral;
import io.crate.sql.tree.Cast;
import io.crate.sql.tree.CharFilters;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.CommitStatement;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CopyTo;
import io.crate.sql.tree.CreateAnalyzer;
import io.crate.sql.tree.CreateBlobTable;
import io.crate.sql.tree.CreateFunction;
import io.crate.sql.tree.CreateRepository;
import io.crate.sql.tree.CreateSnapshot;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.CreateUser;
import io.crate.sql.tree.CreateView;
import io.crate.sql.tree.CurrentTime;
import io.crate.sql.tree.DeallocateStatement;
import io.crate.sql.tree.DecommissionNodeStatement;
import io.crate.sql.tree.Delete;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.DiscardStatement;
import io.crate.sql.tree.DoubleLiteral;
import io.crate.sql.tree.DropAnalyzer;
import io.crate.sql.tree.DropBlobTable;
import io.crate.sql.tree.DropCheckConstraint;
import io.crate.sql.tree.DropFunction;
import io.crate.sql.tree.DropRepository;
import io.crate.sql.tree.DropSnapshot;
import io.crate.sql.tree.DropTable;
import io.crate.sql.tree.DropUser;
import io.crate.sql.tree.DropView;
import io.crate.sql.tree.EscapedCharStringLiteral;
import io.crate.sql.tree.Except;
import io.crate.sql.tree.ExistsPredicate;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Extract;
import io.crate.sql.tree.FrameBound;
import io.crate.sql.tree.FunctionArgument;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.GCDanglingArtifacts;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.GenericProperty;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.IfExpression;
import io.crate.sql.tree.InListExpression;
import io.crate.sql.tree.InPredicate;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.Intersect;
import io.crate.sql.tree.IntervalLiteral;
import io.crate.sql.tree.IsNotNullPredicate;
import io.crate.sql.tree.IsNullPredicate;
import io.crate.sql.tree.Join;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.JoinOn;
import io.crate.sql.tree.JoinUsing;
import io.crate.sql.tree.KillStatement;
import io.crate.sql.tree.LikePredicate;
import io.crate.sql.tree.LogicalBinaryExpression;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.MatchPredicate;
import io.crate.sql.tree.MatchPredicateColumnIdent;
import io.crate.sql.tree.NamedProperties;
import io.crate.sql.tree.NaturalJoin;
import io.crate.sql.tree.NegativeExpression;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.NotExpression;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.NullLiteral;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.OptimizeStatement;
import io.crate.sql.tree.ParameterExpression;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.PrimaryKeyColumnConstraint;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.PromoteReplica;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.QueryBody;
import io.crate.sql.tree.QuerySpecification;
import io.crate.sql.tree.RecordSubscript;
import io.crate.sql.tree.RefreshStatement;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.RerouteAllocateReplicaShard;
import io.crate.sql.tree.RerouteCancelShard;
import io.crate.sql.tree.RerouteMoveShard;
import io.crate.sql.tree.RerouteOption;
import io.crate.sql.tree.ResetStatement;
import io.crate.sql.tree.RestoreSnapshot;
import io.crate.sql.tree.RevokePrivilege;
import io.crate.sql.tree.SearchedCaseExpression;
import io.crate.sql.tree.Select;
import io.crate.sql.tree.SelectItem;
import io.crate.sql.tree.SetSessionAuthorizationStatement;
import io.crate.sql.tree.SetStatement;
import io.crate.sql.tree.SetTransactionStatement;
import io.crate.sql.tree.ShowColumns;
import io.crate.sql.tree.ShowCreateTable;
import io.crate.sql.tree.ShowSchemas;
import io.crate.sql.tree.ShowSessionParameter;
import io.crate.sql.tree.ShowTables;
import io.crate.sql.tree.ShowTransaction;
import io.crate.sql.tree.SimpleCaseExpression;
import io.crate.sql.tree.SingleColumn;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.SwapTable;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableElement;
import io.crate.sql.tree.TableFunction;
import io.crate.sql.tree.TableSubquery;
import io.crate.sql.tree.TokenFilters;
import io.crate.sql.tree.Tokenizer;
import io.crate.sql.tree.TrimMode;
import io.crate.sql.tree.TryCast;
import io.crate.sql.tree.Union;
import io.crate.sql.tree.Update;
import io.crate.sql.tree.Values;
import io.crate.sql.tree.ValuesList;
import io.crate.sql.tree.WhenClause;
import io.crate.sql.tree.Window;
import io.crate.sql.tree.WindowFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

class AstBuilder
extends SqlBaseBaseVisitor<Node> {
    private int parameterPosition = 1;
    private static final String CLUSTER = "CLUSTER";
    private static final String SCHEMA = "SCHEMA";
    private static final String TABLE = "TABLE";
    private static final String VIEW = "VIEW";

    AstBuilder() {
    }

    @Override
    public Node visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
        return (Node)this.visit((ParseTree)context.statement());
    }

    @Override
    public Node visitSingleExpression(SqlBaseParser.SingleExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expr());
    }

    @Override
    public Node visitBegin(SqlBaseParser.BeginContext context) {
        return new BeginStatement();
    }

    @Override
    public Node visitAnalyze(SqlBaseParser.AnalyzeContext ctx) {
        return new AnalyzeStatement();
    }

    @Override
    public Node visitDiscard(SqlBaseParser.DiscardContext ctx) {
        DiscardStatement.Target target;
        if (ctx.ALL() != null) {
            target = DiscardStatement.Target.ALL;
        } else if (ctx.PLANS() != null) {
            target = DiscardStatement.Target.PLANS;
        } else if (ctx.SEQUENCES() != null) {
            target = DiscardStatement.Target.SEQUENCES;
        } else if (ctx.TEMP() != null || ctx.TEMPORARY() != null) {
            target = DiscardStatement.Target.TEMPORARY;
        } else {
            throw new IllegalStateException("Unexpected DiscardContext: " + ctx);
        }
        return new DiscardStatement(target);
    }

    @Override
    public Node visitIntervalLiteral(SqlBaseParser.IntervalLiteralContext context) {
        IntervalLiteral.IntervalField startField = AstBuilder.getIntervalFieldType((Token)context.from.getChild(0).getPayload());
        IntervalLiteral.IntervalField endField = null;
        if (context.to != null) {
            Token token = (Token)context.to.getChild(0).getPayload();
            endField = AstBuilder.getIntervalFieldType(token);
        }
        if (endField != null && startField.compareTo(endField) > 0) {
            throw new IllegalArgumentException("Startfield must be less significant than Endfield");
        }
        IntervalLiteral.Sign sign = IntervalLiteral.Sign.PLUS;
        if (context.sign != null) {
            sign = AstBuilder.getIntervalSign(context.sign);
        }
        return new IntervalLiteral(((StringLiteral)this.visit((ParseTree)context.stringLiteral())).getValue(), sign, startField, endField);
    }

    private static IntervalLiteral.Sign getIntervalSign(Token token) {
        switch (token.getType()) {
            case 269: {
                return IntervalLiteral.Sign.MINUS;
            }
            case 268: {
                return IntervalLiteral.Sign.PLUS;
            }
        }
        throw new IllegalArgumentException("Unsupported sign: " + token.getText());
    }

    private static IntervalLiteral.IntervalField getIntervalFieldType(Token token) {
        switch (token.getType()) {
            case 57: {
                return IntervalLiteral.IntervalField.YEAR;
            }
            case 58: {
                return IntervalLiteral.IntervalField.MONTH;
            }
            case 59: {
                return IntervalLiteral.IntervalField.DAY;
            }
            case 60: {
                return IntervalLiteral.IntervalField.HOUR;
            }
            case 61: {
                return IntervalLiteral.IntervalField.MINUTE;
            }
            case 62: {
                return IntervalLiteral.IntervalField.SECOND;
            }
        }
        throw new IllegalArgumentException("Unsupported interval field: " + token.getText());
    }

    @Override
    public Node visitCommit(SqlBaseParser.CommitContext context) {
        return new CommitStatement();
    }

    @Override
    public Node visitOptimize(SqlBaseParser.OptimizeContext context) {
        return new OptimizeStatement<Expression>(this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateTable(SqlBaseParser.CreateTableContext context) {
        boolean notExists = context.EXISTS() != null;
        SqlBaseParser.PartitionedByOrClusteredIntoContext tableOptsCtx = context.partitionedByOrClusteredInto();
        Optional clusteredBy = this.visitIfPresent(tableOptsCtx.clusteredBy(), ClusteredBy.class);
        Optional partitionedBy = this.visitIfPresent(tableOptsCtx.partitionedBy(), PartitionedBy.class);
        List tableElements = Lists2.map(context.tableElement(), x -> (TableElement)this.visit((ParseTree)x));
        return new CreateTable<Expression>((Table)this.visit((ParseTree)context.table()), tableElements, partitionedBy, clusteredBy, this.extractGenericProperties(context.withProperties()), notExists);
    }

    @Override
    public Node visitAlterClusterSwapTable(SqlBaseParser.AlterClusterSwapTableContext ctx) {
        return new SwapTable<Expression>(this.getQualifiedName(ctx.source), this.getQualifiedName(ctx.target), this.extractGenericProperties(ctx.withProperties()));
    }

    @Override
    public Node visitAlterClusterGCDanglingArtifacts(SqlBaseParser.AlterClusterGCDanglingArtifactsContext ctx) {
        return GCDanglingArtifacts.INSTANCE;
    }

    @Override
    public Node visitAlterClusterDecommissionNode(SqlBaseParser.AlterClusterDecommissionNodeContext ctx) {
        return new DecommissionNodeStatement<Node>((Node)this.visit((ParseTree)ctx.node));
    }

    @Override
    public Node visitCreateView(SqlBaseParser.CreateViewContext ctx) {
        return new CreateView(this.getQualifiedName(ctx.qname()), (Query)this.visit((ParseTree)ctx.query()), ctx.REPLACE() != null);
    }

    @Override
    public Node visitDropView(SqlBaseParser.DropViewContext ctx) {
        return new DropView(this.getQualifiedNames(ctx.qnames()), ctx.EXISTS() != null);
    }

    @Override
    public Node visitCreateBlobTable(SqlBaseParser.CreateBlobTableContext context) {
        return new CreateBlobTable<Expression>((Table)this.visit((ParseTree)context.table()), this.visitIfPresent(context.numShards, ClusteredBy.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateRepository(SqlBaseParser.CreateRepositoryContext context) {
        return new CreateRepository<Expression>(this.getIdentText(context.name), this.getIdentText(context.type), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateSnapshot(SqlBaseParser.CreateSnapshotContext context) {
        if (context.ALL() != null) {
            return new CreateSnapshot<Expression>(this.getQualifiedName(context.qname()), this.extractGenericProperties(context.withProperties()));
        }
        return new CreateSnapshot<Expression>(this.getQualifiedName(context.qname()), this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateAnalyzer(SqlBaseParser.CreateAnalyzerContext context) {
        return new CreateAnalyzer(this.getIdentText(context.name), this.getIdentText(context.extendedName), this.visitCollection(context.analyzerElement(), AnalyzerElement.class));
    }

    @Override
    public Node visitDropAnalyzer(SqlBaseParser.DropAnalyzerContext ctx) {
        return new DropAnalyzer(this.getIdentText(ctx.name));
    }

    @Override
    public Node visitCreateUser(SqlBaseParser.CreateUserContext context) {
        return new CreateUser<Expression>(this.getIdentText(context.name), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitDropUser(SqlBaseParser.DropUserContext context) {
        return new DropUser(this.getIdentText(context.name), context.EXISTS() != null);
    }

    @Override
    public Node visitGrantPrivilege(SqlBaseParser.GrantPrivilegeContext context) {
        List<String> usernames = this.identsToStrings(context.users.ident());
        ClassAndIdent clazzAndIdent = this.getClassAndIdentsForPrivileges(context.ON() == null, context.clazz(), context.qnames());
        if (context.ALL() != null) {
            return new GrantPrivilege(usernames, clazzAndIdent.clazz, clazzAndIdent.idents);
        }
        List<String> privilegeTypes = this.identsToStrings(context.priviliges.ident());
        return new GrantPrivilege(usernames, privilegeTypes, clazzAndIdent.clazz, clazzAndIdent.idents);
    }

    @Override
    public Node visitDenyPrivilege(SqlBaseParser.DenyPrivilegeContext context) {
        List<String> usernames = this.identsToStrings(context.users.ident());
        ClassAndIdent clazzAndIdent = this.getClassAndIdentsForPrivileges(context.ON() == null, context.clazz(), context.qnames());
        if (context.ALL() != null) {
            return new DenyPrivilege(usernames, clazzAndIdent.clazz, clazzAndIdent.idents);
        }
        List<String> privilegeTypes = this.identsToStrings(context.priviliges.ident());
        return new DenyPrivilege(usernames, privilegeTypes, clazzAndIdent.clazz, clazzAndIdent.idents);
    }

    @Override
    public Node visitRevokePrivilege(SqlBaseParser.RevokePrivilegeContext context) {
        List<String> usernames = this.identsToStrings(context.users.ident());
        ClassAndIdent clazzAndIdent = this.getClassAndIdentsForPrivileges(context.ON() == null, context.clazz(), context.qnames());
        if (context.ALL() != null) {
            return new RevokePrivilege(usernames, clazzAndIdent.clazz, clazzAndIdent.idents);
        }
        List<String> privilegeTypes = this.identsToStrings(context.privileges.ident());
        return new RevokePrivilege(usernames, privilegeTypes, clazzAndIdent.clazz, clazzAndIdent.idents);
    }

    @Override
    public Node visitCharFilters(SqlBaseParser.CharFiltersContext context) {
        return new CharFilters(this.visitCollection(context.namedProperties(), NamedProperties.class));
    }

    @Override
    public Node visitTokenFilters(SqlBaseParser.TokenFiltersContext context) {
        return new TokenFilters(this.visitCollection(context.namedProperties(), NamedProperties.class));
    }

    @Override
    public Node visitTokenizer(SqlBaseParser.TokenizerContext context) {
        return new Tokenizer((NamedProperties)this.visit((ParseTree)context.namedProperties()));
    }

    @Override
    public Node visitNamedProperties(SqlBaseParser.NamedPropertiesContext context) {
        return new NamedProperties<Expression>(this.getIdentText(context.ident()), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitRestore(SqlBaseParser.RestoreContext context) {
        if (context.ALL() != null) {
            return new RestoreSnapshot<Expression>(this.getQualifiedName(context.qname()), this.extractGenericProperties(context.withProperties()));
        }
        return new RestoreSnapshot<Expression>(this.getQualifiedName(context.qname()), this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitShowCreateTable(SqlBaseParser.ShowCreateTableContext context) {
        return new ShowCreateTable((Table)this.visit((ParseTree)context.table()));
    }

    @Override
    public Node visitShowTransaction(SqlBaseParser.ShowTransactionContext context) {
        return new ShowTransaction();
    }

    @Override
    public Node visitShowSessionParameter(SqlBaseParser.ShowSessionParameterContext ctx) {
        if (ctx.ALL() != null) {
            return new ShowSessionParameter(null);
        }
        return new ShowSessionParameter(this.getQualifiedName(ctx.qname()));
    }

    @Override
    public Node visitDropTable(SqlBaseParser.DropTableContext context) {
        return new DropTable((Table)this.visit((ParseTree)context.table()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropRepository(SqlBaseParser.DropRepositoryContext context) {
        return new DropRepository(this.getIdentText(context.ident()));
    }

    @Override
    public Node visitDropBlobTable(SqlBaseParser.DropBlobTableContext context) {
        return new DropBlobTable((Table)this.visit((ParseTree)context.table()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropSnapshot(SqlBaseParser.DropSnapshotContext context) {
        return new DropSnapshot(this.getQualifiedName(context.qname()));
    }

    @Override
    public Node visitCopyFrom(SqlBaseParser.CopyFromContext context) {
        boolean returnSummary = context.SUMMARY() != null;
        return new CopyFrom<Expression>((Table)this.visit((ParseTree)context.tableWithPartition()), (Expression)this.visit((ParseTree)context.path), this.extractGenericProperties(context.withProperties()), returnSummary);
    }

    @Override
    public Node visitCopyTo(SqlBaseParser.CopyToContext context) {
        return new CopyTo<Expression>((Table)this.visit((ParseTree)context.tableWithPartition()), (List<Expression>)(context.columns() == null ? Collections.emptyList() : this.visitCollection(context.columns().primaryExpression(), Expression.class)), this.visitIfPresent(context.where(), Expression.class), context.DIRECTORY() != null, (Expression)this.visit((ParseTree)context.path), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitInsert(SqlBaseParser.InsertContext context) {
        Table table;
        List<String> columns = this.identsToStrings(context.ident());
        try {
            table = (Table)this.visit((ParseTree)context.table());
        }
        catch (ClassCastException e) {
            TableFunction tf = (TableFunction)this.visit((ParseTree)context.table());
            for (Expression ex : tf.functionCall().getArguments()) {
                if (ex instanceof QualifiedNameReference) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid table column reference %s", ex.toString()));
            }
            throw e;
        }
        return new Insert(table, (Query)this.visit((ParseTree)context.insertSource().query()), columns, this.getReturningItems(context.returning()), this.createDuplicateKeyContext(context));
    }

    private Insert.DuplicateKeyContext createDuplicateKeyContext(SqlBaseParser.InsertContext context) {
        if (context.onConflict() != null) {
            SqlBaseParser.OnConflictContext onConflictContext = context.onConflict();
            SqlBaseParser.ConflictTargetContext conflictTarget = onConflictContext.conflictTarget();
            List<Object> conflictColumns = conflictTarget == null ? List.of() : this.visitCollection(conflictTarget.subscriptSafe(), Expression.class);
            if (onConflictContext.NOTHING() != null) {
                return new Insert.DuplicateKeyContext<Object>(Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_NOTHING, Collections.emptyList(), conflictColumns);
            }
            if (conflictColumns.isEmpty()) {
                throw new IllegalStateException("ON CONFLICT <conflict_target> <- conflict_target missing");
            }
            List assignments = Lists2.map(onConflictContext.assignment(), x -> (Assignment)this.visit((ParseTree)x));
            return new Insert.DuplicateKeyContext<Object>(Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_UPDATE_SET, assignments, conflictColumns);
        }
        return Insert.DuplicateKeyContext.none();
    }

    @Override
    public Node visitValues(SqlBaseParser.ValuesContext context) {
        return new ValuesList(this.visitCollection(context.expr(), Expression.class));
    }

    @Override
    public Node visitDelete(SqlBaseParser.DeleteContext context) {
        return new Delete((Relation)this.visit((ParseTree)context.aliasedRelation()), this.visitIfPresent(context.where(), Expression.class));
    }

    @Override
    public Node visitUpdate(SqlBaseParser.UpdateContext context) {
        List<Assignment<Expression>> assignments = Lists2.map(context.assignment(), x -> (Assignment)this.visit((ParseTree)x));
        return new Update((Relation)this.visit((ParseTree)context.aliasedRelation()), assignments, this.visitIfPresent(context.where(), Expression.class), this.getReturningItems(context.returning()));
    }

    @Override
    public Node visitSet(SqlBaseParser.SetContext context) {
        Assignment<?> setAssignment = this.prepareSetAssignment(context);
        if (context.LOCAL() != null) {
            return new SetStatement(SetStatement.Scope.LOCAL, setAssignment);
        }
        return new SetStatement(SetStatement.Scope.SESSION, setAssignment);
    }

    private Assignment<?> prepareSetAssignment(SqlBaseParser.SetContext context) {
        QualifiedNameReference settingName = new QualifiedNameReference(this.getQualifiedName(context.qname()));
        if (context.DEFAULT() != null) {
            return new Assignment(settingName, List.of());
        }
        return new Assignment<List<Expression>>((List<Expression>)((Object)settingName), this.visitCollection(context.setExpr(), Expression.class));
    }

    @Override
    public Node visitSetGlobal(SqlBaseParser.SetGlobalContext context) {
        List assignments = Lists2.map(context.setGlobalAssignment(), x -> (Assignment)this.visit((ParseTree)x));
        if (context.PERSISTENT() != null) {
            return new SetStatement(SetStatement.Scope.GLOBAL, SetStatement.SettingType.PERSISTENT, assignments);
        }
        return new SetStatement(SetStatement.Scope.GLOBAL, assignments);
    }

    @Override
    public Node visitSetLicense(SqlBaseParser.SetLicenseContext ctx) {
        Assignment<Expression> assignment = new Assignment<Expression>(new StringLiteral("license"), (Expression)this.visit((ParseTree)ctx.stringLiteral()));
        return new SetStatement(SetStatement.Scope.LICENSE, SetStatement.SettingType.PERSISTENT, Collections.singletonList(assignment));
    }

    @Override
    public Node visitSetTransaction(SqlBaseParser.SetTransactionContext ctx) {
        List<SetTransactionStatement.TransactionMode> modes = Lists2.map(ctx.transactionMode(), AstBuilder::getTransactionMode);
        return new SetTransactionStatement(modes);
    }

    private static SetTransactionStatement.TransactionMode getTransactionMode(SqlBaseParser.TransactionModeContext transactionModeCtx) {
        if (transactionModeCtx.ISOLATION() != null) {
            SqlBaseParser.IsolationLevelContext isolationLevel = transactionModeCtx.isolationLevel();
            if (isolationLevel.COMMITTED() != null) {
                return SetTransactionStatement.IsolationLevel.READ_COMMITTED;
            }
            if (isolationLevel.UNCOMMITTED() != null) {
                return SetTransactionStatement.IsolationLevel.READ_UNCOMMITTED;
            }
            if (isolationLevel.REPEATABLE() != null) {
                return SetTransactionStatement.IsolationLevel.REPEATABLE_READ;
            }
            return SetTransactionStatement.IsolationLevel.SERIALIZABLE;
        }
        if (transactionModeCtx.READ() != null) {
            return SetTransactionStatement.ReadMode.READ_ONLY;
        }
        if (transactionModeCtx.WRITE() != null) {
            return SetTransactionStatement.ReadMode.READ_WRITE;
        }
        if (transactionModeCtx.NOT() != null) {
            return new SetTransactionStatement.Deferrable(true);
        }
        if (transactionModeCtx.DEFERRABLE() != null) {
            return new SetTransactionStatement.Deferrable(false);
        }
        throw new IllegalStateException("Unexpected TransactionModeContext: " + transactionModeCtx);
    }

    @Override
    public Node visitResetGlobal(SqlBaseParser.ResetGlobalContext context) {
        return new ResetStatement<Expression>(this.visitCollection(context.primaryExpression(), Expression.class));
    }

    @Override
    public Node visitSetSessionAuthorization(SqlBaseParser.SetSessionAuthorizationContext context) {
        SetSessionAuthorizationStatement.Scope scope = context.LOCAL() != null ? SetSessionAuthorizationStatement.Scope.LOCAL : SetSessionAuthorizationStatement.Scope.SESSION;
        if (context.DEFAULT() != null) {
            return new SetSessionAuthorizationStatement(scope);
        }
        Node userNameLiteral = (Node)this.visit((ParseTree)context.username);
        assert (userNameLiteral instanceof StringLiteral) : "username must be a StringLiteral because the parser grammar is restricted to string literals";
        String userName = ((StringLiteral)userNameLiteral).getValue();
        return new SetSessionAuthorizationStatement(userName, scope);
    }

    @Override
    public Node visitResetSessionAuthorization(SqlBaseParser.ResetSessionAuthorizationContext ctx) {
        return new SetSessionAuthorizationStatement(SetSessionAuthorizationStatement.Scope.SESSION);
    }

    @Override
    public Node visitKill(SqlBaseParser.KillContext context) {
        return new KillStatement<Expression>(this.visitIfPresent(context.jobId, Expression.class).orElse(null));
    }

    @Override
    public Node visitDeallocate(SqlBaseParser.DeallocateContext context) {
        if (context.ALL() != null) {
            return new DeallocateStatement();
        }
        return new DeallocateStatement((Expression)this.visit((ParseTree)context.prepStmt));
    }

    @Override
    public Node visitExplain(SqlBaseParser.ExplainContext context) {
        return new Explain((Statement)this.visit((ParseTree)context.statement()), context.ANALYZE() != null);
    }

    @Override
    public Node visitShowTables(SqlBaseParser.ShowTablesContext context) {
        return new ShowTables(context.qname() == null ? null : this.getQualifiedName(context.qname()), AstBuilder.getUnquotedText(context.pattern), this.visitIfPresent(context.where(), Expression.class));
    }

    @Override
    public Node visitShowSchemas(SqlBaseParser.ShowSchemasContext context) {
        return new ShowSchemas(AstBuilder.getUnquotedText(context.pattern), this.visitIfPresent(context.where(), Expression.class));
    }

    @Override
    public Node visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
        return new ShowColumns(this.getQualifiedName(context.tableName), context.schema == null ? null : this.getQualifiedName(context.schema), this.visitIfPresent(context.where(), Expression.class), AstBuilder.getUnquotedText(context.pattern));
    }

    @Override
    public Node visitRefreshTable(SqlBaseParser.RefreshTableContext context) {
        return new RefreshStatement(this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class));
    }

    @Override
    public Node visitTableOnly(SqlBaseParser.TableOnlyContext context) {
        return new Table(this.getQualifiedName(context.qname()));
    }

    @Override
    public Node visitTableWithPartition(SqlBaseParser.TableWithPartitionContext context) {
        return new Table(this.getQualifiedName(context.qname()), this.visitCollection(context.assignment(), Assignment.class));
    }

    @Override
    public Node visitCreateFunction(SqlBaseParser.CreateFunctionContext context) {
        QualifiedName functionName = this.getQualifiedName(context.name);
        AstBuilder.validateFunctionName(functionName);
        return new CreateFunction<Expression>(functionName, context.REPLACE() != null, this.visitCollection(context.functionArgument(), FunctionArgument.class), (ColumnType)this.visit((ParseTree)context.returnType), (Expression)this.visit((ParseTree)context.language), (Expression)this.visit((ParseTree)context.body));
    }

    @Override
    public Node visitDropFunction(SqlBaseParser.DropFunctionContext context) {
        QualifiedName functionName = this.getQualifiedName(context.name);
        AstBuilder.validateFunctionName(functionName);
        return new DropFunction(functionName, context.EXISTS() != null, this.visitCollection(context.functionArgument(), FunctionArgument.class));
    }

    @Override
    public Node visitColumnDefinition(SqlBaseParser.ColumnDefinitionContext context) {
        return new ColumnDefinition<Expression>(this.getIdentText(context.ident()), this.visitOptionalContext(context.defaultExpr, Expression.class), this.visitOptionalContext(context.generatedExpr, Expression.class), this.visitOptionalContext(context.dataType(), ColumnType.class), this.visitCollection(context.columnConstraint(), ColumnConstraint.class));
    }

    @Override
    public Node visitColumnConstraintPrimaryKey(SqlBaseParser.ColumnConstraintPrimaryKeyContext context) {
        return new PrimaryKeyColumnConstraint();
    }

    @Override
    public Node visitColumnConstraintNotNull(SqlBaseParser.ColumnConstraintNotNullContext context) {
        return new NotNullColumnConstraint();
    }

    @Override
    public Node visitPrimaryKeyConstraint(SqlBaseParser.PrimaryKeyConstraintContext context) {
        return new PrimaryKeyConstraint<Expression>(this.visitCollection(context.columns().primaryExpression(), Expression.class));
    }

    @Override
    public Node visitTableCheckConstraint(SqlBaseParser.TableCheckConstraintContext context) {
        SqlBaseParser.CheckConstraintContext ctx = context.checkConstraint();
        String name = ctx.CONSTRAINT() != null ? this.getIdentText(ctx.name) : null;
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression);
        String expressionStr = ExpressionFormatter.formatStandaloneExpression(expression);
        return new CheckConstraint<Expression>(name, null, expression, expressionStr);
    }

    @Override
    public Node visitColumnCheckConstraint(SqlBaseParser.ColumnCheckConstraintContext context) {
        SqlBaseParser.CheckConstraintContext ctx = context.checkConstraint();
        String name = ctx.CONSTRAINT() != null ? this.getIdentText(ctx.name) : null;
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression);
        String expressionStr = ExpressionFormatter.formatStandaloneExpression(expression);
        return new CheckColumnConstraint<Expression>(name, null, expression, expressionStr);
    }

    @Override
    public Node visitDropCheckConstraint(SqlBaseParser.DropCheckConstraintContext context) {
        Table table = (Table)this.visit((ParseTree)context.alterTableDefinition());
        return new DropCheckConstraint(table, this.getIdentText(context.ident()));
    }

    @Override
    public Node visitColumnIndexOff(SqlBaseParser.ColumnIndexOffContext context) {
        return IndexColumnConstraint.off();
    }

    @Override
    public Node visitColumnIndexConstraint(SqlBaseParser.ColumnIndexConstraintContext context) {
        return new IndexColumnConstraint<Expression>(this.getIdentText(context.method), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitIndexDefinition(SqlBaseParser.IndexDefinitionContext context) {
        return new IndexDefinition<Expression>(this.getIdentText(context.name), this.getIdentText(context.method), this.visitCollection(context.columns().primaryExpression(), Expression.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitColumnStorageDefinition(SqlBaseParser.ColumnStorageDefinitionContext ctx) {
        return new ColumnStorageDefinition<Expression>(this.extractGenericProperties(ctx.withProperties()));
    }

    @Override
    public Node visitPartitionedBy(SqlBaseParser.PartitionedByContext context) {
        return new PartitionedBy<Expression>(this.visitCollection(context.columns().primaryExpression(), Expression.class));
    }

    @Override
    public Node visitClusteredBy(SqlBaseParser.ClusteredByContext context) {
        return new ClusteredBy<Expression>(this.visitIfPresent(context.routing, Expression.class), this.visitIfPresent(context.numShards, Expression.class));
    }

    @Override
    public Node visitBlobClusteredInto(SqlBaseParser.BlobClusteredIntoContext ctx) {
        return new ClusteredBy<Expression>(Optional.empty(), this.visitIfPresent(ctx.numShards, Expression.class));
    }

    @Override
    public Node visitFunctionArgument(SqlBaseParser.FunctionArgumentContext context) {
        return new FunctionArgument(this.getIdentText(context.ident()), (ColumnType)this.visit((ParseTree)context.dataType()));
    }

    @Override
    public Node visitRerouteMoveShard(SqlBaseParser.RerouteMoveShardContext context) {
        return new RerouteMoveShard<Node>((Node)this.visit((ParseTree)context.shardId), (Node)this.visit((ParseTree)context.fromNodeId), (Node)this.visit((ParseTree)context.toNodeId));
    }

    @Override
    public Node visitReroutePromoteReplica(SqlBaseParser.ReroutePromoteReplicaContext ctx) {
        return new PromoteReplica<Expression>((Expression)this.visit((ParseTree)ctx.nodeId), (Expression)this.visit((ParseTree)ctx.shardId), this.extractGenericProperties(ctx.withProperties()));
    }

    @Override
    public Node visitRerouteAllocateReplicaShard(SqlBaseParser.RerouteAllocateReplicaShardContext context) {
        return new RerouteAllocateReplicaShard<Node>((Node)this.visit((ParseTree)context.shardId), (Node)this.visit((ParseTree)context.nodeId));
    }

    @Override
    public Node visitRerouteCancelShard(SqlBaseParser.RerouteCancelShardContext context) {
        return new RerouteCancelShard<Expression>((Expression)this.visit((ParseTree)context.shardId), (Expression)this.visit((ParseTree)context.nodeId), this.extractGenericProperties(context.withProperties()));
    }

    private GenericProperties<Expression> extractGenericProperties(ParserRuleContext context) {
        return this.visitIfPresent(context, GenericProperties.class).orElse(GenericProperties.empty());
    }

    @Override
    public Node visitWithGenericProperties(SqlBaseParser.WithGenericPropertiesContext context) {
        return this.visitGenericProperties(context.genericProperties());
    }

    @Override
    public Node visitGenericProperties(SqlBaseParser.GenericPropertiesContext context) {
        GenericProperties properties = new GenericProperties();
        context.genericProperty().forEach(p -> properties.add((GenericProperty)this.visit((ParseTree)p)));
        return properties;
    }

    @Override
    public Node visitGenericProperty(SqlBaseParser.GenericPropertyContext context) {
        return new GenericProperty<Expression>(this.getIdentText(context.ident()), (Expression)this.visit((ParseTree)context.expr()));
    }

    @Override
    public Node visitAlterTableProperties(SqlBaseParser.AlterTablePropertiesContext context) {
        Table name = (Table)this.visit((ParseTree)context.alterTableDefinition());
        if (context.SET() != null) {
            return new AlterTable<Expression>(name, this.extractGenericProperties(context.genericProperties()));
        }
        return new AlterTable(name, this.identsToStrings(context.ident()));
    }

    @Override
    public Node visitAlterBlobTableProperties(SqlBaseParser.AlterBlobTablePropertiesContext context) {
        Table name = (Table)this.visit((ParseTree)context.alterTableDefinition());
        if (context.SET() != null) {
            return new AlterBlobTable<Expression>(name, this.extractGenericProperties(context.genericProperties()));
        }
        return new AlterBlobTable(name, this.identsToStrings(context.ident()));
    }

    @Override
    public Node visitAddColumn(SqlBaseParser.AddColumnContext context) {
        return new AlterTableAddColumn((Table)this.visit((ParseTree)context.alterTableDefinition()), (AddColumnDefinition)this.visit((ParseTree)context.addColumnDefinition()));
    }

    @Override
    public Node visitAddColumnDefinition(SqlBaseParser.AddColumnDefinitionContext context) {
        return new AddColumnDefinition<Expression>((Expression)this.visit((ParseTree)context.subscriptSafe()), this.visitOptionalContext(context.expr(), Expression.class), this.visitOptionalContext(context.dataType(), ColumnType.class), this.visitCollection(context.columnConstraint(), ColumnConstraint.class));
    }

    @Override
    public Node visitAlterTableOpenClose(SqlBaseParser.AlterTableOpenCloseContext context) {
        return new AlterTableOpenClose((Table)this.visit((ParseTree)context.alterTableDefinition()), context.BLOB() != null, context.OPEN() != null);
    }

    @Override
    public Node visitAlterTableRename(SqlBaseParser.AlterTableRenameContext context) {
        return new AlterTableRename((Table)this.visit((ParseTree)context.alterTableDefinition()), context.BLOB() != null, this.getQualifiedName(context.qname()));
    }

    @Override
    public Node visitAlterTableReroute(SqlBaseParser.AlterTableRerouteContext context) {
        return new AlterTableReroute((Table)this.visit((ParseTree)context.alterTableDefinition()), context.BLOB() != null, (RerouteOption)this.visit((ParseTree)context.rerouteOption()));
    }

    @Override
    public Node visitAlterClusterRerouteRetryFailed(SqlBaseParser.AlterClusterRerouteRetryFailedContext context) {
        return new AlterClusterRerouteRetryFailed();
    }

    @Override
    public Node visitAlterUser(SqlBaseParser.AlterUserContext context) {
        return new AlterUser<Expression>(this.getIdentText(context.name), this.extractGenericProperties(context.genericProperties()));
    }

    @Override
    public Node visitSetGlobalAssignment(SqlBaseParser.SetGlobalAssignmentContext context) {
        return new Assignment<Expression>((Expression)this.visit((ParseTree)context.primaryExpression()), (Expression)this.visit((ParseTree)context.expr()));
    }

    @Override
    public Node visitAssignment(SqlBaseParser.AssignmentContext context) {
        Expression column = (Expression)this.visit((ParseTree)context.primaryExpression());
        if (column instanceof SubscriptExpression || column instanceof QualifiedNameReference) {
            return new Assignment<Expression>(column, (Expression)this.visit((ParseTree)context.expr()));
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "cannot use expression %s as a left side of an assignment", column));
    }

    @Override
    public Node visitQuery(SqlBaseParser.QueryContext context) {
        QueryBody term = (QueryBody)this.visit((ParseTree)context.queryTerm());
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(new QuerySpecification(query.getSelect(), query.getFrom(), query.getWhere(), query.getGroupBy(), query.getHaving(), query.getWindows(), this.visitCollection(context.sortItem(), SortItem.class), this.visitIfPresent(context.limit, Expression.class), this.visitIfPresent(context.offset, Expression.class)), List.of(), Optional.empty(), Optional.empty());
        }
        return new Query(term, this.visitCollection(context.sortItem(), SortItem.class), this.visitIfPresent(context.limit, Expression.class), this.visitIfPresent(context.offset, Expression.class));
    }

    @Override
    public Node visitDefaultQuerySpec(SqlBaseParser.DefaultQuerySpecContext context) {
        List<SelectItem> selectItems = this.visitCollection(context.selectItem(), SelectItem.class);
        return new QuerySpecification(new Select(AstBuilder.isDistinct(context.setQuant()), selectItems), this.visitCollection(context.relation(), Relation.class), this.visitIfPresent(context.where(), Expression.class), this.visitCollection(context.expr(), Expression.class), this.visitIfPresent(context.having, Expression.class), this.getWindowDefinitions(context.windows), List.of(), Optional.empty(), Optional.empty());
    }

    @Override
    public Node visitValuesRelation(SqlBaseParser.ValuesRelationContext ctx) {
        return new Values(this.visitCollection(ctx.values(), ValuesList.class));
    }

    private Map<String, Window> getWindowDefinitions(List<SqlBaseParser.NamedWindowContext> windowContexts) {
        HashMap<String, Window> windows = new HashMap<String, Window>(windowContexts.size());
        for (SqlBaseParser.NamedWindowContext windowContext : windowContexts) {
            String name = this.getIdentText(windowContext.name);
            if (windows.containsKey(name)) {
                throw new IllegalArgumentException("Window " + name + " is already defined");
            }
            Window window = (Window)this.visit((ParseTree)windowContext.windowDefinition());
            if (window.windowRef() != null && !windows.containsKey(window.windowRef())) {
                throw new IllegalArgumentException("Window " + window.windowRef() + " does not exist");
            }
            windows.put(name, window);
        }
        return windows;
    }

    @Override
    public Node visitWhere(SqlBaseParser.WhereContext context) {
        return (Node)this.visit((ParseTree)context.condition);
    }

    @Override
    public Node visitSortItem(SqlBaseParser.SortItemContext context) {
        return new SortItem((Expression)this.visit((ParseTree)context.expr()), Optional.ofNullable(context.ordering).map(AstBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING), Optional.ofNullable(context.nullOrdering).map(AstBuilder::getNullOrderingType).orElse(SortItem.NullOrdering.UNDEFINED));
    }

    @Override
    public Node visitSetOperation(SqlBaseParser.SetOperationContext context) {
        switch (context.operator.getType()) {
            case 202: {
                QueryBody left = (QueryBody)this.visit((ParseTree)context.left);
                QueryBody right = (QueryBody)this.visit((ParseTree)context.right);
                boolean isDistinct = context.setQuant() == null || context.setQuant().ALL() == null;
                return new Union(left, right, isDistinct);
            }
            case 204: {
                QuerySpecification first = (QuerySpecification)this.visit((ParseTree)context.first);
                QuerySpecification second = (QuerySpecification)this.visit((ParseTree)context.second);
                return new Intersect(first, second);
            }
            case 203: {
                QuerySpecification first = (QuerySpecification)this.visit((ParseTree)context.first);
                QuerySpecification second = (QuerySpecification)this.visit((ParseTree)context.second);
                return new Except(first, second);
            }
        }
        throw new IllegalArgumentException("Unsupported set operation: " + context.operator.getText());
    }

    @Override
    public Node visitSelectAll(SqlBaseParser.SelectAllContext context) {
        if (context.qname() != null) {
            return new AllColumns(this.getQualifiedName(context.qname()));
        }
        return new AllColumns();
    }

    @Override
    public Node visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
        return new SingleColumn((Expression)this.visit((ParseTree)context.expr()), this.getIdentText(context.ident()));
    }

    @Override
    public Node visitArraySubquery(SqlBaseParser.ArraySubqueryContext ctx) {
        return new ArraySubQueryExpression((SubqueryExpression)this.visit((ParseTree)ctx.subqueryExpression()));
    }

    @Override
    public Node visitUnquotedIdentifier(SqlBaseParser.UnquotedIdentifierContext context) {
        return new StringLiteral(context.getText().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Node visitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
        String token = context.getText();
        String identifier = token.substring(1, token.length() - 1).replace("\"\"", "\"");
        return new StringLiteral(identifier);
    }

    @Nullable
    private String getIdentText(@Nullable SqlBaseParser.IdentContext ident) {
        if (ident != null) {
            StringLiteral literal = (StringLiteral)this.visit((ParseTree)ident);
            return literal.getValue();
        }
        return null;
    }

    @Override
    public Node visitTableName(SqlBaseParser.TableNameContext ctx) {
        return new Table(this.getQualifiedName(ctx.qname()), false);
    }

    @Override
    public Node visitTableFunction(SqlBaseParser.TableFunctionContext ctx) {
        QualifiedName qualifiedName = this.getQualifiedName(ctx.qname());
        List<Expression> arguments = this.visitCollection(ctx.valueExpression(), Expression.class);
        return new TableFunction(new FunctionCall(qualifiedName, arguments));
    }

    @Override
    public Node visitLogicalNot(SqlBaseParser.LogicalNotContext context) {
        return new NotExpression((Expression)this.visit((ParseTree)context.booleanExpression()));
    }

    @Override
    public Node visitLogicalBinary(SqlBaseParser.LogicalBinaryContext context) {
        return new LogicalBinaryExpression(AstBuilder.getLogicalBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
        JoinCriteria criteria;
        Relation right;
        Relation left = (Relation)this.visit((ParseTree)context.left);
        if (context.CROSS() != null) {
            Relation right2 = (Relation)this.visit((ParseTree)context.right);
            return new Join(Join.Type.CROSS, left, right2, Optional.empty());
        }
        if (context.NATURAL() != null) {
            right = (Relation)this.visit((ParseTree)context.right);
            criteria = new NaturalJoin();
        } else {
            right = (Relation)this.visit((ParseTree)context.rightRelation);
            if (context.joinCriteria().ON() != null) {
                criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
            } else if (context.joinCriteria().USING() != null) {
                List<String> columns = this.identsToStrings(context.joinCriteria().ident());
                criteria = new JoinUsing(columns);
            } else {
                throw new IllegalArgumentException("Unsupported join criteria");
            }
        }
        return new Join(AstBuilder.getJoinType(context.joinType()), left, right, Optional.of(criteria));
    }

    private static Join.Type getJoinType(SqlBaseParser.JoinTypeContext joinTypeContext) {
        Join.Type joinType = joinTypeContext.LEFT() != null ? Join.Type.LEFT : (joinTypeContext.RIGHT() != null ? Join.Type.RIGHT : (joinTypeContext.FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        return joinType;
    }

    @Override
    public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.relationPrimary());
        if (context.ident() == null) {
            return child;
        }
        return new AliasedRelation(child, this.getIdentText(context.ident()), this.getColumnAliases(context.aliasedColumns()));
    }

    @Override
    public Node visitSubqueryRelation(SqlBaseParser.SubqueryRelationContext context) {
        return new TableSubquery((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitParenthesizedRelation(SqlBaseParser.ParenthesizedRelationContext context) {
        return (Node)this.visit((ParseTree)context.relation());
    }

    @Override
    public Node visitPredicated(SqlBaseParser.PredicatedContext context) {
        if (context.predicate() != null) {
            return (Node)this.visit((ParseTree)context.predicate());
        }
        return (Node)this.visit((ParseTree)context.valueExpression);
    }

    @Override
    public Node visitComparison(SqlBaseParser.ComparisonContext context) {
        return new ComparisonExpression(AstBuilder.getComparisonOperator(((TerminalNode)context.cmpOp().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitDistinctFrom(SqlBaseParser.DistinctFromContext context) {
        Expression expression = new ComparisonExpression(ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        if (context.NOT() != null) {
            expression = new NotExpression(expression);
        }
        return expression;
    }

    @Override
    public Node visitBetween(SqlBaseParser.BetweenContext context) {
        Expression expression = new BetweenPredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
        if (context.NOT() != null) {
            expression = new NotExpression(expression);
        }
        return expression;
    }

    @Override
    public Node visitNullPredicate(SqlBaseParser.NullPredicateContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.value);
        if (context.NOT() == null) {
            return new IsNullPredicate(child);
        }
        return new IsNotNullPredicate(child);
    }

    @Override
    public Node visitLike(SqlBaseParser.LikeContext context) {
        Expression escape = null;
        if (context.escape != null) {
            escape = (Expression)this.visit((ParseTree)context.escape);
        }
        boolean ignoreCase = context.LIKE() == null && context.ILIKE() != null;
        Expression result = new LikePredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), escape, ignoreCase);
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitArrayLike(SqlBaseParser.ArrayLikeContext context) {
        boolean inverse = context.NOT() != null;
        boolean ignoreCase = context.LIKE() == null && context.ILIKE() != null;
        return new ArrayLikePredicate(AstBuilder.getComparisonQuantifier(((TerminalNode)context.setCmpQuantifier().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.v), this.visitOptionalContext(context.escape, Expression.class), inverse, ignoreCase);
    }

    @Override
    public Node visitInList(SqlBaseParser.InListContext context) {
        Expression result = new InPredicate((Expression)this.visit((ParseTree)context.value), new InListExpression(this.visitCollection(context.expr(), Expression.class)));
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitInSubquery(SqlBaseParser.InSubqueryContext context) {
        Expression result = new InPredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.subqueryExpression()));
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitExists(SqlBaseParser.ExistsContext context) {
        return new ExistsPredicate((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitQuantifiedComparison(SqlBaseParser.QuantifiedComparisonContext context) {
        return new ArrayComparisonExpression(AstBuilder.getComparisonOperator(((TerminalNode)context.cmpOp().getChild(0)).getSymbol()), AstBuilder.getComparisonQuantifier(((TerminalNode)context.setCmpQuantifier().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.primaryExpression()));
    }

    @Override
    public Node visitMatch(SqlBaseParser.MatchContext context) {
        SqlBaseParser.MatchPredicateIdentsContext predicateIdents = context.matchPredicateIdents();
        List<MatchPredicateColumnIdent> idents = predicateIdents.matchPred != null ? List.of((MatchPredicateColumnIdent)this.visit((ParseTree)predicateIdents.matchPred)) : this.visitCollection(predicateIdents.matchPredicateIdent(), MatchPredicateColumnIdent.class);
        return new MatchPredicate(idents, (Expression)this.visit((ParseTree)context.term), this.getIdentText(context.matchType), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitMatchPredicateIdent(SqlBaseParser.MatchPredicateIdentContext context) {
        return new MatchPredicateColumnIdent((Expression)this.visit((ParseTree)context.subscriptSafe()), this.visitOptionalContext(context.boost, Expression.class));
    }

    @Override
    public Node visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext context) {
        switch (context.operator.getType()) {
            case 269: {
                return new NegativeExpression((Expression)this.visit((ParseTree)context.valueExpression()));
            }
            case 268: {
                return (Node)this.visit((ParseTree)context.valueExpression());
            }
        }
        throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
    }

    @Override
    public Node visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext context) {
        return new ArithmeticExpression(AstBuilder.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitConcatenation(SqlBaseParser.ConcatenationContext context) {
        return new FunctionCall(QualifiedName.of("concat", new String[0]), List.of((Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right)));
    }

    @Override
    public Node visitOver(SqlBaseParser.OverContext context) {
        return (Node)this.visit((ParseTree)context.windowDefinition());
    }

    @Override
    public Node visitWindowDefinition(SqlBaseParser.WindowDefinitionContext context) {
        return new Window(this.getIdentText(context.windowRef), this.visitCollection(context.partition, Expression.class), this.visitCollection(context.sortItem(), SortItem.class), this.visitIfPresent(context.windowFrame(), WindowFrame.class));
    }

    @Override
    public Node visitWindowFrame(SqlBaseParser.WindowFrameContext ctx) {
        return new WindowFrame(AstBuilder.getFrameType(ctx.frameType), (FrameBound)this.visit((ParseTree)ctx.start), this.visitIfPresent(ctx.end, FrameBound.class));
    }

    @Override
    public Node visitUnboundedFrame(SqlBaseParser.UnboundedFrameContext context) {
        return new FrameBound(AstBuilder.getUnboundedFrameBoundType(context.boundType));
    }

    @Override
    public Node visitBoundedFrame(SqlBaseParser.BoundedFrameContext context) {
        return new FrameBound(AstBuilder.getBoundedFrameBoundType(context.boundType), (Expression)this.visit((ParseTree)context.expr()));
    }

    @Override
    public Node visitCurrentRowBound(SqlBaseParser.CurrentRowBoundContext context) {
        return new FrameBound(FrameBound.Type.CURRENT_ROW);
    }

    @Override
    public Node visitDoubleColonCast(SqlBaseParser.DoubleColonCastContext context) {
        return new Cast((Expression)this.visit((ParseTree)context.primaryExpression()), (ColumnType)this.visit((ParseTree)context.dataType()));
    }

    @Override
    public Node visitFromStringLiteralCast(SqlBaseParser.FromStringLiteralCastContext context) {
        ColumnType targetType = (ColumnType)this.visit((ParseTree)context.dataType());
        if (targetType instanceof CollectionColumnType || targetType instanceof ObjectColumnType) {
            throw new UnsupportedOperationException("type 'string' cast notation only supports primitive types. Use '::' or cast() operator instead.");
        }
        return new Cast((Expression)this.visit((ParseTree)context.stringLiteral()), targetType);
    }

    @Override
    public Node visitCast(SqlBaseParser.CastContext context) {
        if (context.TRY_CAST() != null) {
            return new TryCast((Expression)this.visit((ParseTree)context.expr()), (ColumnType)this.visit((ParseTree)context.dataType()));
        }
        return new Cast((Expression)this.visit((ParseTree)context.expr()), (ColumnType)this.visit((ParseTree)context.dataType()));
    }

    @Override
    public Node visitSpecialDateTimeFunction(SqlBaseParser.SpecialDateTimeFunctionContext context) {
        CurrentTime.Type type = AstBuilder.getDateTimeFunctionType(context.name);
        if (context.precision != null) {
            return new CurrentTime(type, Integer.parseInt(context.precision.getText()));
        }
        return new CurrentTime(type);
    }

    @Override
    public Node visitExtract(SqlBaseParser.ExtractContext context) {
        return new Extract((Expression)this.visit((ParseTree)context.expr()), (StringLiteral)this.visit((ParseTree)context.stringLiteralOrIdentifier()));
    }

    @Override
    public Node visitSubstring(SqlBaseParser.SubstringContext context) {
        return new FunctionCall(QualifiedName.of("substr", new String[0]), this.visitCollection(context.expr(), Expression.class));
    }

    @Override
    public Node visitAtTimezone(SqlBaseParser.AtTimezoneContext context) {
        Expression zone = (Expression)this.visit((ParseTree)context.zone);
        Expression timestamp = (Expression)this.visit((ParseTree)context.timestamp);
        return new FunctionCall(QualifiedName.of("timezone", new String[0]), List.of(zone, timestamp));
    }

    @Override
    public Node visitLeft(SqlBaseParser.LeftContext context) {
        Expression strOrColName = (Expression)this.visit((ParseTree)context.strOrColName);
        Expression len = (Expression)this.visit((ParseTree)context.len);
        return new FunctionCall(QualifiedName.of("left", new String[0]), List.of(strOrColName, len));
    }

    @Override
    public Node visitRight(SqlBaseParser.RightContext context) {
        Expression strOrColName = (Expression)this.visit((ParseTree)context.strOrColName);
        Expression len = (Expression)this.visit((ParseTree)context.len);
        return new FunctionCall(QualifiedName.of("right", new String[0]), List.of(strOrColName, len));
    }

    @Override
    public Node visitTrim(SqlBaseParser.TrimContext ctx) {
        Expression target = (Expression)this.visit((ParseTree)ctx.target);
        if (ctx.charsToTrim == null && ctx.trimMode == null) {
            return new FunctionCall(QualifiedName.of("trim", new String[0]), List.of(target));
        }
        Expression charsToTrim = this.visitIfPresent(ctx.charsToTrim, Expression.class).orElse(new StringLiteral(" "));
        StringLiteral trimMode = new StringLiteral(this.getTrimMode(ctx.trimMode).value());
        return new FunctionCall(QualifiedName.of("trim", new String[0]), List.of(target, charsToTrim, trimMode));
    }

    @Override
    public Node visitCurrentSchema(SqlBaseParser.CurrentSchemaContext context) {
        return new FunctionCall(QualifiedName.of("current_schema", new String[0]), List.of());
    }

    @Override
    public Node visitCurrentUser(SqlBaseParser.CurrentUserContext ctx) {
        return new FunctionCall(QualifiedName.of("current_user", new String[0]), List.of());
    }

    @Override
    public Node visitSessionUser(SqlBaseParser.SessionUserContext ctx) {
        return new FunctionCall(QualifiedName.of("session_user", new String[0]), List.of());
    }

    @Override
    public Node visitNestedExpression(SqlBaseParser.NestedExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expr());
    }

    @Override
    public Node visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext context) {
        return new SubqueryExpression((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitDereference(SqlBaseParser.DereferenceContext context) {
        return new QualifiedNameReference(QualifiedName.of(this.identsToStrings(context.ident())));
    }

    @Override
    public Node visitRecordSubscript(SqlBaseParser.RecordSubscriptContext ctx) {
        return new RecordSubscript((Expression)this.visit((ParseTree)ctx.base), this.getIdentText(ctx.fieldName));
    }

    @Override
    public Node visitColumnReference(SqlBaseParser.ColumnReferenceContext context) {
        return new QualifiedNameReference(QualifiedName.of(this.getIdentText(context.ident()), new String[0]));
    }

    @Override
    public Node visitSubscript(SqlBaseParser.SubscriptContext context) {
        return new SubscriptExpression((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitSubscriptSafe(SqlBaseParser.SubscriptSafeContext context) {
        if (context.qname() != null) {
            return new QualifiedNameReference(this.getQualifiedName(context.qname()));
        }
        return new SubscriptExpression((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitQname(SqlBaseParser.QnameContext context) {
        return new QualifiedNameReference(this.getQualifiedName(context));
    }

    @Override
    public Node visitSimpleCase(SqlBaseParser.SimpleCaseContext context) {
        return new SimpleCaseExpression((Expression)this.visit((ParseTree)context.operand), this.visitCollection(context.whenClause(), WhenClause.class), this.visitOptionalContext(context.elseExpr, Expression.class));
    }

    @Override
    public Node visitSearchedCase(SqlBaseParser.SearchedCaseContext context) {
        return new SearchedCaseExpression(this.visitCollection(context.whenClause(), WhenClause.class), this.visitOptionalContext(context.elseExpr, Expression.class));
    }

    @Override
    public Node visitIfCase(SqlBaseParser.IfCaseContext context) {
        return new IfExpression((Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.trueValue), this.visitIfPresent(context.falseValue, Expression.class));
    }

    @Override
    public Node visitWhenClause(SqlBaseParser.WhenClauseContext context) {
        return new WhenClause((Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
    }

    @Override
    public Node visitFilter(SqlBaseParser.FilterContext context) {
        return (Node)this.visit((ParseTree)context.where());
    }

    @Override
    public Node visitFunctionCall(SqlBaseParser.FunctionCallContext context) {
        return new FunctionCall(this.getQualifiedName(context.qname()), AstBuilder.isDistinct(context.setQuant()), this.visitCollection(context.expr(), Expression.class), this.visitIfPresent(context.over(), Window.class), this.visitIfPresent(context.filter(), Expression.class));
    }

    @Override
    public Node visitNullLiteral(SqlBaseParser.NullLiteralContext context) {
        return NullLiteral.INSTANCE;
    }

    @Override
    public Node visitStringLiteral(SqlBaseParser.StringLiteralContext context) {
        return new StringLiteral(AstBuilder.unquote(context.STRING().getText()));
    }

    @Override
    public Node visitEscapedCharsStringLiteral(SqlBaseParser.EscapedCharsStringLiteralContext ctx) {
        return new EscapedCharStringLiteral(AstBuilder.unquoteEscaped(ctx.ESCAPED_STRING().getText()));
    }

    @Override
    public Node visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
        long value = Long.parseLong(context.getText());
        if (value < 0x80000000L) {
            return new IntegerLiteral((int)value);
        }
        return new LongLiteral(value);
    }

    @Override
    public Node visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
        return new DoubleLiteral(context.getText());
    }

    @Override
    public Node visitBooleanLiteral(SqlBaseParser.BooleanLiteralContext context) {
        return context.TRUE() != null ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL;
    }

    @Override
    public Node visitArrayLiteral(SqlBaseParser.ArrayLiteralContext context) {
        return new ArrayLiteral(this.visitCollection(context.expr(), Expression.class));
    }

    @Override
    public Node visitEmptyArray(SqlBaseParser.EmptyArrayContext ctx) {
        return new ArrayLiteral(List.of());
    }

    @Override
    public Node visitObjectLiteral(SqlBaseParser.ObjectLiteralContext context) {
        LinkedHashMap<String, Expression> expressions = new LinkedHashMap<String, Expression>();
        context.objectKeyValue().forEach(attr -> {
            String key = this.getIdentText(attr.key);
            Expression prevEntry = expressions.put(key, (Expression)this.visit((ParseTree)attr.value));
            if (prevEntry != null) {
                throw new IllegalArgumentException("Object literal cannot contain duplicate keys (`" + key + "`)");
            }
        });
        return new ObjectLiteral(expressions);
    }

    @Override
    public Node visitParameterPlaceholder(SqlBaseParser.ParameterPlaceholderContext context) {
        return new ParameterExpression(this.parameterPosition++);
    }

    @Override
    public Node visitPositionalParameter(SqlBaseParser.PositionalParameterContext context) {
        return new ParameterExpression(Integer.parseInt(context.integerLiteral().getText()));
    }

    @Override
    public Node visitOn(SqlBaseParser.OnContext context) {
        return BooleanLiteral.TRUE_LITERAL;
    }

    @Override
    public Node visitArrayDataType(SqlBaseParser.ArrayDataTypeContext ctx) {
        return new CollectionColumnType((ColumnType)this.visit((ParseTree)ctx.dataType()));
    }

    @Override
    public Node visitObjectTypeDefinition(SqlBaseParser.ObjectTypeDefinitionContext context) {
        return new ObjectColumnType(AstBuilder.getObjectType(context.type), this.visitCollection(context.columnDefinition(), ColumnDefinition.class));
    }

    @Override
    public Node visitMaybeParametrizedDataType(SqlBaseParser.MaybeParametrizedDataTypeContext context) {
        StringLiteral name = (StringLiteral)this.visit((ParseTree)context.baseDataType());
        ArrayList<Integer> parameters = new ArrayList<Integer>(context.integerLiteral().size());
        for (SqlBaseParser.IntegerLiteralContext param : context.integerLiteral()) {
            Node literal = (Node)this.visit((ParseTree)param);
            int val = literal instanceof LongLiteral ? Math.toIntExact(((LongLiteral)literal).getValue()) : ((IntegerLiteral)literal).getValue();
            parameters.add(val);
        }
        return new ColumnType(name.getValue(), parameters);
    }

    @Override
    public Node visitIdentDataType(SqlBaseParser.IdentDataTypeContext context) {
        return StringLiteral.fromObject(this.getIdentText(context.ident()));
    }

    @Override
    public Node visitDefinedDataType(SqlBaseParser.DefinedDataTypeContext context) {
        return StringLiteral.fromObject(context.children.stream().map(c -> c.getText().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" ")));
    }

    private static String getObjectType(Token type) {
        if (type == null) {
            return null;
        }
        switch (type.getType()) {
            case 233: {
                return type.getText().toLowerCase(Locale.ENGLISH);
            }
            case 234: {
                return type.getText().toLowerCase(Locale.ENGLISH);
            }
            case 235: {
                return type.getText().toLowerCase(Locale.ENGLISH);
            }
        }
        throw new UnsupportedOperationException("Unsupported object type: " + type.getText());
    }

    protected Node defaultResult() {
        return null;
    }

    protected Node aggregateResult(Node aggregate, Node nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Nullable
    private <T> T visitOptionalContext(@Nullable ParserRuleContext context, Class<T> clazz) {
        if (context != null) {
            return clazz.cast(this.visit((ParseTree)context));
        }
        return null;
    }

    private <T> Optional<T> visitIfPresent(@Nullable ParserRuleContext context, Class<T> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast);
    }

    private <T> List<T> visitCollection(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
    }

    private static String unquote(String value) {
        return value.substring(1, value.length() - 1).replace("''", "'");
    }

    private static String unquoteEscaped(String value) {
        return value.substring(2, value.length() - 1);
    }

    private List<SelectItem> getReturningItems(@Nullable SqlBaseParser.ReturningContext context) {
        return context == null ? List.of() : this.visitCollection(context.selectItem(), SelectItem.class);
    }

    private QualifiedName getQualifiedName(SqlBaseParser.QnameContext context) {
        return QualifiedName.of(this.identsToStrings(context.ident()));
    }

    private QualifiedName getQualifiedName(SqlBaseParser.IdentContext context) {
        return QualifiedName.of(this.getIdentText(context), new String[0]);
    }

    private List<QualifiedName> getQualifiedNames(SqlBaseParser.QnamesContext context) {
        ArrayList<QualifiedName> names = new ArrayList<QualifiedName>(context.qname().size());
        for (SqlBaseParser.QnameContext qnameContext : context.qname()) {
            names.add(this.getQualifiedName(qnameContext));
        }
        return names;
    }

    private List<String> identsToStrings(List<SqlBaseParser.IdentContext> idents) {
        return idents.stream().map(this::getIdentText).collect(Collectors.toList());
    }

    private static boolean isDistinct(SqlBaseParser.SetQuantContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    @Nullable
    private static String getUnquotedText(@Nullable ParserRuleContext context) {
        return context != null ? AstBuilder.unquote(context.getText()) : null;
    }

    private List<String> getColumnAliases(SqlBaseParser.AliasedColumnsContext columnAliasesContext) {
        if (columnAliasesContext == null) {
            return List.of();
        }
        return this.identsToStrings(columnAliasesContext.ident());
    }

    private static ArithmeticExpression.Type getArithmeticBinaryOperator(Token operator) {
        switch (operator.getType()) {
            case 268: {
                return ArithmeticExpression.Type.ADD;
            }
            case 269: {
                return ArithmeticExpression.Type.SUBTRACT;
            }
            case 270: {
                return ArithmeticExpression.Type.MULTIPLY;
            }
            case 271: {
                return ArithmeticExpression.Type.DIVIDE;
            }
            case 272: {
                return ArithmeticExpression.Type.MODULUS;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
    }

    private TrimMode getTrimMode(Token type) {
        if (type == null) {
            return TrimMode.BOTH;
        }
        switch (type.getType()) {
            case 53: {
                return TrimMode.BOTH;
            }
            case 51: {
                return TrimMode.LEADING;
            }
            case 52: {
                return TrimMode.TRAILING;
            }
        }
        throw new UnsupportedOperationException("Unsupported trim mode: " + type.getText());
    }

    private static ComparisonExpression.Type getComparisonOperator(Token symbol) {
        switch (symbol.getType()) {
            case 257: {
                return ComparisonExpression.Type.EQUAL;
            }
            case 258: {
                return ComparisonExpression.Type.NOT_EQUAL;
            }
            case 259: {
                return ComparisonExpression.Type.LESS_THAN;
            }
            case 260: {
                return ComparisonExpression.Type.LESS_THAN_OR_EQUAL;
            }
            case 261: {
                return ComparisonExpression.Type.GREATER_THAN;
            }
            case 262: {
                return ComparisonExpression.Type.GREATER_THAN_OR_EQUAL;
            }
            case 263: {
                return ComparisonExpression.Type.CONTAINED_WITHIN;
            }
            case 264: {
                return ComparisonExpression.Type.REGEX_MATCH;
            }
            case 265: {
                return ComparisonExpression.Type.REGEX_NO_MATCH;
            }
            case 266: {
                return ComparisonExpression.Type.REGEX_MATCH_CI;
            }
            case 267: {
                return ComparisonExpression.Type.REGEX_NO_MATCH_CI;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + symbol.getText());
    }

    private static CurrentTime.Type getDateTimeFunctionType(Token token) {
        switch (token.getType()) {
            case 63: {
                return CurrentTime.Type.DATE;
            }
            case 64: {
                return CurrentTime.Type.TIME;
            }
            case 65: {
                return CurrentTime.Type.TIMESTAMP;
            }
        }
        throw new UnsupportedOperationException("Unsupported special function: " + token.getText());
    }

    private static LogicalBinaryExpression.Type getLogicalBinaryOperator(Token token) {
        switch (token.getType()) {
            case 32: {
                return LogicalBinaryExpression.Type.AND;
            }
            case 31: {
                return LogicalBinaryExpression.Type.OR;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + token.getText());
    }

    private static SortItem.NullOrdering getNullOrderingType(Token token) {
        switch (token.getType()) {
            case 44: {
                return SortItem.NullOrdering.FIRST;
            }
            case 45: {
                return SortItem.NullOrdering.LAST;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        switch (token.getType()) {
            case 47: {
                return SortItem.Ordering.ASCENDING;
            }
            case 48: {
                return SortItem.Ordering.DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static String getClazz(Token token) {
        switch (token.getType()) {
            case 254: {
                return SCHEMA;
            }
            case 103: {
                return TABLE;
            }
            case 196: {
                return VIEW;
            }
        }
        throw new IllegalArgumentException("Unsupported privilege class: " + token.getText());
    }

    private static ArrayComparison.Quantifier getComparisonQuantifier(Token symbol) {
        switch (symbol.getType()) {
            case 18: {
                return ArrayComparison.Quantifier.ALL;
            }
            case 19: {
                return ArrayComparison.Quantifier.ANY;
            }
            case 20: {
                return ArrayComparison.Quantifier.ANY;
            }
        }
        throw new IllegalArgumentException("Unsupported quantifier: " + symbol.getText());
    }

    private List<QualifiedName> getIdents(List<SqlBaseParser.QnameContext> qnames) {
        return qnames.stream().map(this::getQualifiedName).collect(Collectors.toList());
    }

    private static void validateFunctionName(QualifiedName functionName) {
        if (functionName.getParts().size() > 2) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The function name is not correct! name [%s] does not conform the [[schema_name .] function_name] format.", functionName));
        }
    }

    private ClassAndIdent getClassAndIdentsForPrivileges(boolean onCluster, SqlBaseParser.ClazzContext clazz, SqlBaseParser.QnamesContext qnamesContext) {
        if (onCluster) {
            return new ClassAndIdent(CLUSTER, Collections.emptyList());
        }
        return new ClassAndIdent(AstBuilder.getClazz(clazz.getStart()), this.getIdents(qnamesContext.qname()));
    }

    private static WindowFrame.Mode getFrameType(Token type) {
        switch (type.getType()) {
            case 91: {
                return WindowFrame.Mode.RANGE;
            }
            case 92: {
                return WindowFrame.Mode.ROWS;
            }
        }
        throw new IllegalArgumentException("Unsupported frame type: " + type.getText());
    }

    private static FrameBound.Type getBoundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 94: {
                return FrameBound.Type.PRECEDING;
            }
            case 95: {
                return FrameBound.Type.FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static FrameBound.Type getUnboundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 94: {
                return FrameBound.Type.UNBOUNDED_PRECEDING;
            }
            case 95: {
                return FrameBound.Type.UNBOUNDED_FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static class ClassAndIdent {
        private final String clazz;
        private final List<QualifiedName> idents;

        ClassAndIdent(String clazz, List<QualifiedName> idents) {
            this.clazz = clazz;
            this.idents = idents;
        }
    }
}

