/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql;

import io.crate.common.collections.Lists2;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.Identifiers;
import io.crate.sql.Literals;
import io.crate.sql.tree.AliasedRelation;
import io.crate.sql.tree.AllColumns;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CreateFunction;
import io.crate.sql.tree.CreateSnapshot;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.CreateUser;
import io.crate.sql.tree.DecommissionNodeStatement;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.DropAnalyzer;
import io.crate.sql.tree.DropBlobTable;
import io.crate.sql.tree.DropFunction;
import io.crate.sql.tree.DropRepository;
import io.crate.sql.tree.DropSnapshot;
import io.crate.sql.tree.DropTable;
import io.crate.sql.tree.DropUser;
import io.crate.sql.tree.DropView;
import io.crate.sql.tree.EscapedCharStringLiteral;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.FunctionArgument;
import io.crate.sql.tree.GCDanglingArtifacts;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.IntervalLiteral;
import io.crate.sql.tree.Join;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.JoinOn;
import io.crate.sql.tree.JoinUsing;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.NaturalJoin;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.PrimaryKeyColumnConstraint;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.PrivilegeStatement;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.QuerySpecification;
import io.crate.sql.tree.RefreshStatement;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.RevokePrivilege;
import io.crate.sql.tree.Select;
import io.crate.sql.tree.SelectItem;
import io.crate.sql.tree.SetSessionAuthorizationStatement;
import io.crate.sql.tree.SingleColumn;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SwapTable;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableFunction;
import io.crate.sql.tree.TableSubquery;
import io.crate.sql.tree.Union;
import io.crate.sql.tree.Update;
import io.crate.sql.tree.Values;
import io.crate.sql.tree.ValuesList;
import io.crate.sql.tree.Window;
import io.crate.sql.tree.WindowFrame;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final Collector<CharSequence, ?, String> COMMA_JOINER = Collectors.joining(", ");

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        return SqlFormatter.formatSql(root, null);
    }

    public static String formatSql(Node root, @Nullable List<Expression> parameters) {
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder, parameters);
        root.accept(formatter, 0);
        return builder.toString();
    }

    static String formatSortItem(SortItem sortItem, List<Expression> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(ExpressionFormatter.formatStandaloneExpression(sortItem.getSortKey(), parameters));
        switch (sortItem.getOrdering()) {
            case ASCENDING: {
                sb.append(" ASC");
                break;
            }
            case DESCENDING: {
                sb.append(" DESC");
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown ordering: " + sortItem.getOrdering());
            }
        }
        switch (sortItem.getNullOrdering()) {
            case FIRST: {
                sb.append(" NULLS FIRST");
                break;
            }
            case LAST: {
                sb.append(" NULLS LAST");
                break;
            }
        }
        return sb.toString();
    }

    private static void appendAliasColumns(StringBuilder builder, List<String> columns) {
        if (!columns.isEmpty()) {
            builder.append(" (").append(String.join((CharSequence)", ", columns)).append(')');
        }
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;
        @Nullable
        private final List<Expression> parameters;

        Formatter(StringBuilder builder, @Nullable List<Expression> parameters) {
            this.builder = builder;
            this.parameters = parameters;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public Void visitSwapTable(SwapTable swapTable, Integer indent) {
            this.append(indent, "ALTER CLUSTER SWAP TABLE ");
            this.append(indent, swapTable.source().toString());
            this.append(indent, " TO ");
            this.append(indent, swapTable.target().toString());
            if (!swapTable.properties().isEmpty()) {
                this.append(indent, " ");
                swapTable.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitGCDanglingArtifacts(GCDanglingArtifacts gcDanglingArtifacts, Integer indent) {
            this.append(indent, "ALTER CLUSTER GC DANGLING ARTIFACTS");
            return null;
        }

        @Override
        public Void visitAlterClusterDecommissionNode(DecommissionNodeStatement<?> decommissionNode, Integer indent) {
            this.append(indent, "ALTER CLUSTER DECOMMISSION ");
            ((Expression)decommissionNode.nodeIdOrName()).accept(this, indent);
            return null;
        }

        @Override
        public Void visitCopyFrom(CopyFrom<?> node, Integer indent) {
            CopyFrom<?> copyFrom = node;
            this.append(indent, "COPY ");
            copyFrom.table().accept(this, indent);
            this.append(indent, " FROM ");
            ((Expression)copyFrom.path()).accept(this, indent);
            if (!copyFrom.properties().isEmpty()) {
                this.append(indent, " ");
                copyFrom.properties().accept(this, indent);
            }
            if (copyFrom.isReturnSummary()) {
                this.append(indent, " RETURN SUMMARY");
            }
            return null;
        }

        @Override
        public Void visitRefreshStatement(RefreshStatement node, Integer indent) {
            this.append(indent, "REFRESH TABLE ");
            this.appendFlatNodeList(node.tables(), indent);
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.append(indent, "EXPLAIN");
            if (node.isAnalyze()) {
                this.builder.append(" ANALYZE");
            }
            return null;
        }

        @Override
        public Void visitInsert(Insert<?> node, Integer indent) {
            Iterator<SelectItem> returning;
            this.append(indent, "INSERT");
            this.builder.append(' ');
            this.append(indent, "INTO");
            this.builder.append(' ');
            node.table().accept(this, indent);
            this.builder.append(' ');
            Iterator<String> columns = node.columns().iterator();
            if (columns.hasNext()) {
                this.builder.append('(');
                while (columns.hasNext()) {
                    this.builder.append(columns.next());
                    if (!columns.hasNext()) continue;
                    this.builder.append(", ");
                }
                this.builder.append(')');
            }
            this.builder.append(' ');
            node.insertSource().accept(this, indent);
            Insert.DuplicateKeyContext<?> duplicateKeyContext = node.duplicateKeyContext();
            if (duplicateKeyContext.getType() != Insert.DuplicateKeyContext.Type.NONE) {
                this.builder.append(" ON CONFLICT");
                Iterator<?> constraintColumns = duplicateKeyContext.getConstraintColumns().iterator();
                if (constraintColumns.hasNext()) {
                    this.builder.append(" (");
                    while (constraintColumns.hasNext()) {
                        this.builder.append(constraintColumns.next());
                        if (!constraintColumns.hasNext()) continue;
                        this.builder.append(", ");
                    }
                    this.builder.append(')');
                }
                switch (duplicateKeyContext.getType()) {
                    case ON_CONFLICT_DO_NOTHING: {
                        this.builder.append(" DO NOTHING");
                        break;
                    }
                    case ON_CONFLICT_DO_UPDATE_SET: {
                        this.builder.append(" DO UPDATE");
                        Iterator<Assignment<?>> assignments = duplicateKeyContext.getAssignments().iterator();
                        if (!assignments.hasNext()) break;
                        this.builder.append(" SET ");
                        while (assignments.hasNext()) {
                            assignments.next().accept(this, indent);
                            if (!assignments.hasNext()) continue;
                            this.builder.append(", ");
                        }
                        break;
                    }
                }
            }
            if ((returning = node.returningClause().iterator()).hasNext()) {
                this.append(indent, "RETURNING");
                while (returning.hasNext()) {
                    this.builder.append(' ');
                    returning.next().accept(this, indent);
                    if (!returning.hasNext()) continue;
                    this.builder.append(',');
                }
            }
            return null;
        }

        @Override
        public Void visitUpdate(Update node, Integer indent) {
            this.append(indent, "UPDATE");
            this.builder.append(' ');
            node.relation().accept(this, indent);
            this.builder.append(' ');
            if (!node.assignments().isEmpty()) {
                this.append(indent, "SET");
                this.builder.append(' ');
                Iterator<Assignment<Expression>> assignments = node.assignments().iterator();
                while (assignments.hasNext()) {
                    assignments.next().accept(this, indent);
                    if (!assignments.hasNext()) continue;
                    this.builder.append(',');
                }
                this.builder.append(' ');
            }
            node.whereClause().ifPresent(x -> {
                this.append(indent, "WHERE");
                this.builder.append(' ');
                x.accept(this, indent);
                this.builder.append(' ');
            });
            if (!node.returningClause().isEmpty()) {
                this.append(indent, "RETURNING");
                Iterator<SelectItem> returningItems = node.returningClause().iterator();
                while (returningItems.hasNext()) {
                    this.builder.append(' ');
                    returningItems.next().accept(this, indent);
                    if (!returningItems.hasNext()) continue;
                    this.builder.append(',');
                }
            }
            return null;
        }

        @Override
        public Void visitAssignment(Assignment<?> node, Integer indent) {
            Assignment<?> assignment = node;
            ((Expression)assignment.columnName()).accept(this, indent);
            this.append(indent, "=");
            ((Expression)assignment.expression()).accept(this, indent);
            return null;
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatStandaloneExpression(node, this.parameters));
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            node.getQueryBody().accept(this, indent);
            if (!node.getOrderBy().isEmpty()) {
                this.append(indent, "ORDER BY " + node.getOrderBy().stream().map(e -> SqlFormatter.formatSortItem(e, this.parameters)).collect(COMMA_JOINER)).append('\n');
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            if (node.getOffset().isPresent()) {
                this.append(indent, "OFFSET " + node.getOffset().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            node.getSelect().accept(this, indent);
            if (!node.getFrom().isEmpty()) {
                this.append(indent, "FROM");
                if (node.getFrom().size() > 1) {
                    this.builder.append('\n');
                    this.append(indent, "  ");
                    Iterator<Relation> relations = node.getFrom().iterator();
                    while (relations.hasNext()) {
                        relations.next().accept(this, indent);
                        if (!relations.hasNext()) continue;
                        this.builder.append('\n');
                        this.append(indent, ", ");
                    }
                } else {
                    this.builder.append(' ');
                    Lists2.getOnlyElement(node.getFrom()).accept(this, indent);
                }
            }
            this.builder.append('\n');
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatter.formatStandaloneExpression(node.getWhere().get(), this.parameters)).append('\n');
            }
            if (!node.getGroupBy().isEmpty()) {
                this.append(indent, "GROUP BY " + node.getGroupBy().stream().map(e -> ExpressionFormatter.formatStandaloneExpression(e, this.parameters)).collect(COMMA_JOINER)).append('\n');
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatter.formatStandaloneExpression(node.getHaving().get(), this.parameters)).append('\n');
            }
            if (!node.getWindows().isEmpty()) {
                this.append(indent, "WINDOW ");
                Iterator<Map.Entry<String, Window>> windows = node.getWindows().entrySet().iterator();
                while (windows.hasNext()) {
                    Map.Entry<String, Window> window = windows.next();
                    this.append(indent, window.getKey()).append(" AS ");
                    window.getValue().accept(this, indent);
                    if (!windows.hasNext()) continue;
                    this.append(indent, ", ");
                }
                this.builder.append('\n');
            }
            if (!node.getOrderBy().isEmpty()) {
                this.append(indent, "ORDER BY " + node.getOrderBy().stream().map(e -> SqlFormatter.formatSortItem(e, this.parameters)).collect(COMMA_JOINER)).append('\n');
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            if (node.getOffset().isPresent()) {
                this.append(indent, "OFFSET " + node.getOffset().get()).append('\n');
            }
            return null;
        }

        @Override
        public Void visitValues(Values values, Integer indent) {
            this.append(indent, "VALUES ");
            List<ValuesList> rows = values.rows();
            for (int i = 0; i < rows.size(); ++i) {
                ValuesList row = rows.get(i);
                this.append(indent, "(");
                List<Expression> expressions = row.values();
                for (int j = 0; j < expressions.size(); ++j) {
                    Expression value = expressions.get(j);
                    this.append(indent, ExpressionFormatter.formatExpression(value));
                    if (j + 1 >= expressions.size()) continue;
                    this.append(indent, ", ");
                }
                this.append(indent, ")");
                if (i + 1 >= rows.size()) continue;
                this.append(indent, ", ");
            }
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    item.accept(this, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                Lists2.getOnlyElement(node.getSelectItems()).accept(this, indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatStandaloneExpression(node.getExpression(), this.parameters));
            if (node.getAlias() != null) {
                this.builder.append(' ').append(Formatter.quoteIdentifierIfNeeded(node.getAlias()));
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer indent) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        public Void visitTableFunction(TableFunction node, Integer context) {
            this.builder.append(node.name());
            this.builder.append("(");
            Iterator<Expression> iterator = node.functionCall().getArguments().iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                expression.accept(this, context);
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitTable(Table<?> node, Integer indent) {
            if (node.excludePartitions()) {
                this.builder.append("ONLY ");
            }
            this.builder.append(Formatter.formatQualifiedName(node.getName()));
            if (!node.partitionProperties().isEmpty()) {
                this.builder.append(" PARTITION (");
                for (Assignment<?> assignment : node.partitionProperties()) {
                    this.builder.append(assignment.columnName().toString());
                    this.builder.append("=");
                    this.builder.append(assignment.expression().toString());
                }
                this.builder.append(")");
            }
            return null;
        }

        @Override
        public Void visitCreateTable(CreateTable node, Integer indent) {
            Optional partitionedBy;
            this.builder.append("CREATE TABLE ");
            if (node.ifNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            node.name().accept(this, indent);
            this.builder.append(" ");
            this.appendNestedNodeList(node.tableElements(), indent);
            Optional clusteredBy = node.clusteredBy();
            if (clusteredBy.isPresent()) {
                this.builder.append("\n");
                clusteredBy.get().accept(this, indent);
            }
            if ((partitionedBy = node.partitionedBy()).isPresent()) {
                this.builder.append("\n");
                partitionedBy.get().accept(this, indent);
            }
            if (!node.properties().isEmpty()) {
                this.builder.append("\n");
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitCreateFunction(CreateFunction node, Integer indent) {
            this.builder.append("CREATE");
            if (node.replace()) {
                this.builder.append(" OR REPLACE");
            }
            this.builder.append(" FUNCTION ").append(node.name());
            this.appendFlatNodeList(node.arguments(), indent);
            this.builder.append(" RETURNS ").append(node.returnType()).append(" ").append(" LANGUAGE ").append(node.language().toString().replace("'", "")).append(" ").append(" AS ").append(node.definition().toString());
            return null;
        }

        @Override
        public Void visitCreateUser(CreateUser node, Integer indent) {
            this.builder.append("CREATE USER ").append(Formatter.quoteIdentifierIfNeeded(node.name()));
            if (!node.properties().isEmpty()) {
                this.builder.append("\n");
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitGrantPrivilege(GrantPrivilege node, Integer indent) {
            this.builder.append("GRANT ");
            this.appendPrivilegeStatement(node);
            return null;
        }

        @Override
        public Void visitDenyPrivilege(DenyPrivilege node, Integer context) {
            this.builder.append("DENY ");
            this.appendPrivilegeStatement(node);
            return null;
        }

        @Override
        public Void visitRevokePrivilege(RevokePrivilege node, Integer indent) {
            this.builder.append("REVOKE ");
            this.appendPrivilegeStatement(node);
            return null;
        }

        @Override
        public Void visitDropUser(DropUser node, Integer indent) {
            this.builder.append("DROP USER ");
            if (node.ifExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.quoteIdentifierIfNeeded(node.name()));
            return null;
        }

        @Override
        public Void visitFunctionArgument(FunctionArgument node, Integer context) {
            String name = node.name();
            if (name != null) {
                this.builder.append(name).append(" ");
            }
            this.builder.append(node.type());
            return null;
        }

        @Override
        public Void visitClusteredBy(ClusteredBy node, Integer indent) {
            this.append(indent, "CLUSTERED");
            if (node.column().isPresent()) {
                this.builder.append(String.format(Locale.ENGLISH, " BY (%s)", node.column().get().toString()));
            }
            if (node.numberOfShards().isPresent()) {
                this.builder.append(String.format(Locale.ENGLISH, " INTO %s SHARDS", node.numberOfShards().get()));
            }
            return null;
        }

        @Override
        public Void visitGenericProperties(GenericProperties node, Integer indent) {
            int count = 0;
            int max = node.properties().size();
            if (max > 0) {
                this.builder.append("WITH (\n");
                TreeMap sortedMap = new TreeMap(node.properties());
                for (Map.Entry propertyEntry : sortedMap.entrySet()) {
                    this.builder.append(Formatter.indentString(indent + 1));
                    String key = propertyEntry.getKey();
                    if (propertyEntry.getKey().contains(".")) {
                        key = String.format(Locale.ENGLISH, "\"%s\"", key);
                    }
                    this.builder.append(key).append(" = ");
                    ((Expression)propertyEntry.getValue()).accept(this, indent);
                    if (++count < max) {
                        this.builder.append(",");
                    }
                    this.builder.append("\n");
                }
                this.append(indent, ")");
            }
            return null;
        }

        @Override
        protected Void visitLongLiteral(LongLiteral node, Integer indent) {
            this.builder.append(node.getValue());
            return null;
        }

        @Override
        protected Void visitIntegerLiteral(IntegerLiteral node, Integer indent) {
            this.builder.append(node.getValue());
            return null;
        }

        @Override
        protected Void visitStringLiteral(StringLiteral node, Integer indent) {
            this.builder.append(Literals.quoteStringLiteral(node.getValue()));
            return null;
        }

        @Override
        protected Void visitEscapedCharStringLiteral(EscapedCharStringLiteral node, Integer context) {
            this.builder.append(Literals.quoteEscapedStringLiteral(node.getRawValue()));
            return null;
        }

        @Override
        public Void visitColumnDefinition(ColumnDefinition<?> node, Integer indent) {
            ColumnDefinition<?> columnDefinition = node;
            this.builder.append(Formatter.quoteIdentifierIfNeeded(columnDefinition.ident())).append(" ");
            ColumnType<?> type = columnDefinition.type();
            if (type != null) {
                type.accept(this, indent);
            }
            if (columnDefinition.defaultExpression() != null) {
                this.builder.append(" DEFAULT ").append(ExpressionFormatter.formatStandaloneExpression((Expression)columnDefinition.defaultExpression(), this.parameters));
            }
            if (columnDefinition.generatedExpression() != null) {
                this.builder.append(" GENERATED ALWAYS AS ").append(ExpressionFormatter.formatStandaloneExpression((Expression)columnDefinition.generatedExpression(), this.parameters));
            }
            if (!columnDefinition.constraints().isEmpty()) {
                for (ColumnConstraint<?> constraint : columnDefinition.constraints()) {
                    this.builder.append(" ");
                    constraint.accept(this, indent);
                }
            }
            return null;
        }

        @Override
        public Void visitColumnType(ColumnType node, Integer indent) {
            this.builder.append(node.name().toUpperCase(Locale.ENGLISH));
            if (node.parametrized()) {
                this.builder.append("(").append((Object)node.parameters().stream().map(String::valueOf).collect(Collectors.joining(", "))).append(')');
            }
            return null;
        }

        @Override
        public Void visitObjectColumnType(ObjectColumnType node, Integer indent) {
            ObjectColumnType objectColumnType = node;
            this.builder.append("OBJECT");
            if (objectColumnType.objectType().isPresent()) {
                this.builder.append('(');
                this.builder.append(objectColumnType.objectType().get().name());
                this.builder.append(')');
            }
            if (!objectColumnType.nestedColumns().isEmpty()) {
                this.builder.append(" AS ");
                this.appendNestedNodeList(objectColumnType.nestedColumns(), indent);
            }
            return null;
        }

        @Override
        public Void visitCollectionColumnType(CollectionColumnType node, Integer indent) {
            this.builder.append(node.name().toUpperCase(Locale.ENGLISH)).append("(");
            node.innerType().accept(this, indent);
            this.builder.append(")");
            return null;
        }

        @Override
        public Void visitIndexColumnConstraint(IndexColumnConstraint node, Integer indent) {
            this.builder.append("INDEX ");
            if (node.equals(IndexColumnConstraint.off())) {
                this.builder.append(node.indexMethod().toUpperCase(Locale.ENGLISH));
            } else {
                this.builder.append("USING ").append(node.indexMethod().toUpperCase(Locale.ENGLISH));
                if (!node.properties().isEmpty()) {
                    this.builder.append(" ");
                    node.properties().accept(this, indent);
                }
            }
            return null;
        }

        @Override
        public Void visitColumnStorageDefinition(ColumnStorageDefinition node, Integer indent) {
            this.builder.append("STORAGE ");
            if (!node.properties().isEmpty()) {
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitPrimaryKeyColumnConstraint(PrimaryKeyColumnConstraint node, Integer indent) {
            this.builder.append("PRIMARY KEY");
            return null;
        }

        @Override
        public Void visitNotNullColumnConstraint(NotNullColumnConstraint node, Integer indent) {
            this.builder.append("NOT NULL");
            return null;
        }

        @Override
        public Void visitPrimaryKeyConstraint(PrimaryKeyConstraint node, Integer indent) {
            this.builder.append("PRIMARY KEY ");
            this.appendFlatNodeList(node.columns(), indent);
            return null;
        }

        private void visitCheckConstraint(@Nullable String uniqueName, String expressionStr) {
            if (uniqueName != null) {
                this.builder.append("CONSTRAINT ").append(uniqueName).append(" ");
            }
            this.builder.append("CHECK(").append(expressionStr).append(")");
        }

        @Override
        public Void visitCheckConstraint(CheckConstraint<?> node, Integer indent) {
            this.visitCheckConstraint(node.name(), node.expressionStr());
            return null;
        }

        @Override
        public Void visitCheckColumnConstraint(CheckColumnConstraint<?> node, Integer indent) {
            this.visitCheckConstraint(node.name(), node.expressionStr());
            return null;
        }

        @Override
        public Void visitIndexDefinition(IndexDefinition node, Integer indent) {
            this.builder.append("INDEX ").append(Formatter.quoteIdentifierIfNeeded(node.ident())).append(" USING ").append(node.method().toUpperCase(Locale.ENGLISH)).append(" ");
            this.appendFlatNodeList(node.columns(), indent);
            if (!node.properties().isEmpty()) {
                this.builder.append(" ");
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitPartitionedBy(PartitionedBy node, Integer indent) {
            this.append(indent, "PARTITIONED BY ");
            this.appendFlatNodeList(node.columns(), indent);
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer context) {
            node.getLeft().accept(this, context);
            this.builder.append("UNION ");
            if (!node.isDistinct()) {
                this.builder.append(" ALL");
            }
            this.builder.append(" ");
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            Object type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + (String)type;
            }
            this.builder.append('(');
            node.getLeft().accept(this, indent);
            this.builder.append('\n');
            this.append(indent, (String)type).append(" JOIN ");
            node.getRight().accept(this, indent);
            if (criteria instanceof JoinUsing) {
                JoinUsing using = (JoinUsing)criteria;
                this.builder.append(" USING (").append(String.join((CharSequence)", ", using.getColumns())).append(")");
            } else if (criteria instanceof JoinOn) {
                JoinOn on = (JoinOn)criteria;
                this.builder.append(" ON (").append(ExpressionFormatter.formatStandaloneExpression(on.getExpression(), this.parameters)).append(")");
            } else if (node.getType() != Join.Type.CROSS && !(criteria instanceof NaturalJoin)) {
                throw new UnsupportedOperationException("unknown join criteria: " + criteria);
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            node.getRelation().accept(this, indent);
            this.builder.append(' ').append(node.getAlias());
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            node.getQuery().accept(this, indent + 1);
            this.append(indent, ")");
            return null;
        }

        @Override
        public Void visitDropRepository(DropRepository node, Integer indent) {
            this.builder.append("DROP REPOSITORY ").append(Formatter.quoteIdentifierIfNeeded(node.name()));
            return null;
        }

        @Override
        public Void visitCreateSnapshot(CreateSnapshot<?> node, Integer indent) {
            this.builder.append("CREATE SNAPSHOT ").append(Formatter.formatQualifiedName(node.name()));
            if (!node.tables().isEmpty()) {
                this.builder.append(" TABLE ");
                int count = 0;
                int max = node.tables().size();
                for (Table<?> table : node.tables()) {
                    table.accept(this, indent);
                    if (++count >= max) continue;
                    this.builder.append(",");
                }
            } else {
                this.builder.append(" ALL");
            }
            if (!node.properties().isEmpty()) {
                this.builder.append(' ');
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitDropTable(DropTable<?> node, Integer indent) {
            this.builder.append("DROP TABLE ");
            if (node.dropIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            node.table().accept(this, indent);
            return null;
        }

        @Override
        public Void visitDropBlobTable(DropBlobTable<?> node, Integer indent) {
            this.builder.append("DROP BLOB TABLE ");
            if (node.ignoreNonExistentTable()) {
                this.builder.append("IF EXISTS ");
            }
            node.table().accept(this, indent);
            return null;
        }

        @Override
        public Void visitDropView(DropView node, Integer indent) {
            this.builder.append("DROP VIEW ");
            if (node.ifExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.names().stream().map(Formatter::formatQualifiedName).collect(COMMA_JOINER));
            return null;
        }

        @Override
        public Void visitIntervalLiteral(IntervalLiteral node, Integer indent) {
            this.builder.append(IntervalLiteral.format(node));
            return null;
        }

        @Override
        public Void visitDropAnalyzer(DropAnalyzer node, Integer indent) {
            this.builder.append("DROP ANALYZER ").append(Formatter.quoteIdentifierIfNeeded(node.name()));
            return null;
        }

        @Override
        public Void visitDropFunction(DropFunction node, Integer indent) {
            this.builder.append("DROP FUNCTION ");
            if (node.exists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.formatQualifiedName(node.name()));
            this.appendFlatNodeList(node.arguments(), indent);
            return null;
        }

        @Override
        public Void visitDropSnapshot(DropSnapshot node, Integer indent) {
            this.builder.append("DROP REPOSITORY ").append(Formatter.formatQualifiedName(node.name()));
            return null;
        }

        @Override
        public Void visitWindow(Window window, Integer indent) {
            this.append(indent, "(");
            if (window.windowRef() != null) {
                this.append(indent, window.windowRef());
            }
            if (!window.getPartitions().isEmpty()) {
                this.append(indent, " PARTITION BY ");
                Iterator<Expression> partitions = window.getPartitions().iterator();
                while (partitions.hasNext()) {
                    partitions.next().accept(this, indent);
                    if (!partitions.hasNext()) continue;
                    this.append(indent, ", ");
                }
            }
            if (!window.getOrderBy().isEmpty()) {
                this.append(indent, " ORDER BY ");
                Iterator<SortItem> sortItems = window.getOrderBy().iterator();
                while (sortItems.hasNext()) {
                    sortItems.next().accept(this, indent);
                    if (!sortItems.hasNext()) continue;
                    this.append(indent, ", ");
                }
            }
            window.getWindowFrame().map(frame -> frame.accept(this, indent));
            this.append(indent, ")");
            return null;
        }

        @Override
        public Void visitWindowFrame(WindowFrame frame, Integer indent) {
            this.append(indent, " ");
            this.append(indent, frame.mode().name());
            this.append(indent, " ");
            Expression startOffset = frame.getStart().getValue();
            if (startOffset != null) {
                startOffset.accept(this, indent);
                this.append(indent, " ");
            }
            this.append(indent, frame.getStart().getType().name());
            frame.getEnd().map(end -> {
                this.append(indent, " AND ");
                Expression endOffset = end.getValue();
                if (endOffset != null) {
                    endOffset.accept(this, indent);
                    this.append(indent, " ");
                }
                this.append(indent, end.getType().name());
                return null;
            });
            return null;
        }

        @Override
        protected Void visitSortItem(SortItem node, Integer indent) {
            node.getSortKey().accept(this, indent);
            return null;
        }

        @Override
        public Void visitSetSessionAuthorizationStatement(SetSessionAuthorizationStatement node, Integer context) {
            String user = node.user();
            this.builder.append("SET ").append((Object)node.scope()).append(" SESSION AUTHORIZATION ").append(user != null ? Formatter.quoteIdentifierIfNeeded(user) : "DEFAULT");
            return null;
        }

        private void appendPrivilegesList(List<String> privilegeTypes) {
            int j = 0;
            for (String privilegeType : privilegeTypes) {
                this.builder.append(privilegeType);
                if (j < privilegeTypes.size() - 1) {
                    this.builder.append(", ");
                }
                ++j;
            }
        }

        private void appendUsersList(List<String> userNames) {
            for (int i = 0; i < userNames.size(); ++i) {
                this.builder.append(Formatter.quoteIdentifierIfNeeded(userNames.get(i)));
                if (i >= userNames.size() - 1) continue;
                this.builder.append(", ");
            }
        }

        private void appendTableOrSchemaNames(List<QualifiedName> tableOrSchemaNames) {
            for (int i = 0; i < tableOrSchemaNames.size(); ++i) {
                this.builder.append(Formatter.quoteIdentifierIfNeeded(tableOrSchemaNames.get(i).toString()));
                if (i >= tableOrSchemaNames.size() - 1) continue;
                this.builder.append(", ");
            }
        }

        private void appendPrivilegeStatement(PrivilegeStatement node) {
            if (node.privileges().isEmpty()) {
                this.builder.append(" ALL ");
            } else {
                this.appendPrivilegesList(node.privileges());
            }
            if (!node.clazz().equals("CLUSTER")) {
                this.builder.append(" ON " + node.clazz() + " ");
                this.appendTableOrSchemaNames(node.privilegeIdents());
            }
            if (node instanceof RevokePrivilege) {
                this.builder.append(" FROM ");
            } else {
                this.builder.append(" TO ");
            }
            this.appendUsersList(node.userNames());
        }

        private static String formatQualifiedName(QualifiedName name) {
            return name.getParts().stream().map(Formatter::quoteIdentifierIfNeeded).collect(Collectors.joining("."));
        }

        private static String quoteIdentifierIfNeeded(String identifier) {
            return Arrays.stream(identifier.split("\\.")).map(Identifiers::quote).collect(Collectors.joining("."));
        }

        private void appendFlatNodeList(List<? extends Node> nodes, Integer indent) {
            int count = 0;
            int max = nodes.size();
            this.builder.append("(");
            for (Node node : nodes) {
                node.accept(this, indent);
                if (++count >= max) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
        }

        private void appendNestedNodeList(List<? extends Node> nodes, Integer indent) {
            int count = 0;
            int max = nodes.size();
            this.builder.append("(\n");
            for (Node node : nodes) {
                this.builder.append(Formatter.indentString(indent + 1));
                node.accept(this, indent + 1);
                if (++count < max) {
                    this.builder.append(",");
                }
                this.builder.append("\n");
            }
            this.append(indent, ")");
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return String.join((CharSequence)"", Collections.nCopies(indent, SqlFormatter.INDENT));
        }
    }
}

