/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql;

import java.util.function.Predicate;

public class Literals {
    private static final String EPSILON = "E";
    static final String ESCAPED_UNICODE_ERROR = "Invalid Unicode escape (must be \\uXXXX or \\UXXXXXXXX)";

    public static String quoteStringLiteral(String literal) {
        return "'" + Literals.escapeStringLiteral(literal) + "'";
    }

    public static String quoteEscapedStringLiteral(String literal) {
        return "E'" + literal + "'";
    }

    static String escapeStringLiteral(String literal) {
        return literal.replace("'", "''");
    }

    public static String replaceEscapedChars(String input) {
        int length = input.length();
        if (input.length() <= 1) {
            return input;
        }
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char nextChar;
            char currentChar = input.charAt(i);
            if (currentChar == '\\' && i + 1 < length) {
                nextChar = input.charAt(i + 1);
                switch (nextChar) {
                    case 'b': {
                        builder.append('\b');
                        ++i;
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        ++i;
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        ++i;
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        ++i;
                        break;
                    }
                    case '\'': 
                    case '\\': {
                        builder.append(nextChar);
                        ++i;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        int charsToConsume;
                        int n = charsToConsume = nextChar == 'u' ? 4 : 8;
                        if (i + 1 + charsToConsume >= length) {
                            throw new IllegalArgumentException(ESCAPED_UNICODE_ERROR);
                        }
                        int endIdx = Literals.calculateMaxCharsInSequence(input, i + 2, charsToConsume, Literals::isHexDigit);
                        if (endIdx != i + 2 + charsToConsume) {
                            throw new IllegalArgumentException(ESCAPED_UNICODE_ERROR);
                        }
                        builder.appendCodePoint(Integer.parseInt(input, i + 2, endIdx, 16));
                        i = endIdx - 1;
                        break;
                    }
                    case 'x': {
                        int endIdx = Literals.calculateMaxCharsInSequence(input, i + 2, 2, Literals::isHexDigit);
                        if (endIdx > i + 2) {
                            builder.appendCodePoint(Integer.parseInt(input, i + 2, endIdx, 16));
                            i = endIdx - 1;
                            break;
                        }
                        builder.append(nextChar);
                        ++i;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        int endIdx = Literals.calculateMaxCharsInSequence(input, i + 2, 2, Literals::isOctalDigit);
                        builder.appendCodePoint(Integer.parseInt(input, i + 1, endIdx, 8));
                        i = endIdx - 1;
                        break;
                    }
                    default: {
                        builder.append(currentChar);
                        break;
                    }
                }
                continue;
            }
            if (currentChar == '\'' && i > 1 && i + 1 < length) {
                nextChar = input.charAt(i + 1);
                if (nextChar == '\'') {
                    builder.append(currentChar);
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("Invalid Escaped String Literal " + input);
            }
            builder.append(currentChar);
        }
        return builder.toString();
    }

    private static boolean isOctalDigit(char ch) {
        return ch >= '0' && ch <= '7';
    }

    private static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    private static int calculateMaxCharsInSequence(CharSequence seq, int beginIndex, int maxCharsToMatch, Predicate<Character> predicate) {
        int idx;
        int end = Math.min(seq.length(), beginIndex + maxCharsToMatch);
        for (idx = beginIndex; idx < end && predicate.test(Character.valueOf(seq.charAt(idx))); ++idx) {
        }
        return idx;
    }
}

