/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql;

import io.crate.sql.parser.ParsingException;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.parser.antlr.v4.SqlBaseLexer;
import io.crate.sql.tree.QualifiedNameReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Vocabulary;

public class Identifiers {
    private static final Pattern IDENTIFIER = Pattern.compile("(^[a-z_]+[a-z0-9_]*)");
    private static final Pattern ESCAPE_REPLACE_RE = Pattern.compile("\"", 16);
    private static final String ESCAPE_REPLACEMENT = Matcher.quoteReplacement("\"\"");
    public static final Collection<Keyword> KEYWORDS = Identifiers.identifierCandidates();
    static final Set<String> RESERVED_KEYWORDS = KEYWORDS.stream().filter(Keyword::isReserved).map(Keyword::getWord).collect(Collectors.toSet());

    public static String quote(String identifier) {
        return "\"" + Identifiers.escape(identifier) + "\"";
    }

    public static String quoteIfNeeded(String identifier) {
        if (Identifiers.quotesRequired(identifier)) {
            return Identifiers.quote(identifier);
        }
        return identifier;
    }

    public static String maybeQuoteExpression(String expression) {
        int length = expression.length();
        if (length == 0) {
            return "\"\"";
        }
        if (Identifiers.isKeyWord(expression)) {
            return "\"" + expression + "\"";
        }
        StringBuilder sb = new StringBuilder();
        boolean addQuotes = false;
        int subscriptStartPos = -1;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if (c == '\"') {
                sb.append('\"');
            }
            sb.append(c);
            if (subscriptStartPos != -1) continue;
            if (c == '[' && i + 1 < length && expression.charAt(i + 1) == '\'') {
                subscriptStartPos = i;
                continue;
            }
            addQuotes = addQuotes || Identifiers.charIsOutsideSafeRange(i, c);
        }
        if (addQuotes) {
            sb.insert(0, '\"');
            if (subscriptStartPos == -1) {
                sb.append('\"');
            } else {
                sb.insert(subscriptStartPos + 1, '\"');
            }
        }
        return sb.toString();
    }

    private static boolean charIsOutsideSafeRange(int i, char c) {
        if (i == 0) {
            return c != '_' && (c < 'a' || c > 'z');
        }
        return !(c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9');
    }

    private static boolean quotesRequired(String identifier) {
        return Identifiers.isKeyWord(identifier) || !IDENTIFIER.matcher(identifier).matches();
    }

    public static boolean isKeyWord(String identifier) {
        return RESERVED_KEYWORDS.contains(identifier.toUpperCase(Locale.ENGLISH));
    }

    private static boolean reserved(String expression) {
        try {
            return !(SqlParser.createExpression(expression) instanceof QualifiedNameReference);
        }
        catch (ParsingException ignored) {
            return true;
        }
    }

    private static Set<Keyword> identifierCandidates() {
        HashSet<Keyword> candidates = new HashSet<Keyword>();
        Vocabulary vocabulary = SqlBaseLexer.VOCABULARY;
        for (int i = 0; i < vocabulary.getMaxTokenType(); ++i) {
            Matcher matcher;
            String literal = vocabulary.getLiteralName(i);
            if (literal == null || !(matcher = IDENTIFIER.matcher((literal = literal.replace("'", "")).toLowerCase(Locale.ENGLISH))).matches()) continue;
            candidates.add(new Keyword(literal, Identifiers.reserved(literal)));
        }
        return candidates;
    }

    public static String escape(String identifier) {
        return ESCAPE_REPLACE_RE.matcher(identifier).replaceAll(ESCAPE_REPLACEMENT);
    }

    public static class Keyword {
        private final String word;
        private final boolean reserved;

        public Keyword(String word, boolean reserved) {
            this.word = word;
            this.reserved = reserved;
        }

        public String getWord() {
            return this.word;
        }

        public boolean isReserved() {
            return this.reserved;
        }
    }
}

