/*
 * Decompiled with CFR 0.152.
 */
package io.crate.settings;

import io.crate.common.StringUtils;
import io.crate.types.DataType;
import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class CrateSetting<T> {
    private final Setting<T> setting;
    private final DataType<?> dataType;
    private final List<String> path;
    private final Boolean isGroupSetting;

    public static <T> CrateSetting<T> of(Setting<T> setting, DataType<?> dataType) {
        return new CrateSetting<T>(setting, dataType);
    }

    private CrateSetting(Setting<T> setting, DataType<?> dataType) {
        this.setting = setting;
        this.dataType = dataType;
        this.isGroupSetting = setting.getKey().endsWith(".");
        this.path = StringUtils.splitToList('.', setting.getKey());
    }

    public Setting<T> setting() {
        return this.setting;
    }

    public DataType<?> dataType() {
        return this.dataType;
    }

    public List<String> path() {
        return this.path;
    }

    public String getKey() {
        return this.setting.getKey();
    }

    public T getDefault() {
        return this.setting.getDefault(Settings.EMPTY);
    }

    public boolean isGroupSetting() {
        return this.isGroupSetting;
    }
}

