/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.action.sql.DescribeResult;
import io.crate.action.sql.ResultReceiver;
import io.crate.action.sql.SQLOperations;
import io.crate.action.sql.Session;
import io.crate.action.sql.SessionContext;
import io.crate.action.sql.parser.SQLRequestParseContext;
import io.crate.action.sql.parser.SQLRequestParser;
import io.crate.auth.AuthSettings;
import io.crate.auth.user.AccessControl;
import io.crate.auth.user.User;
import io.crate.auth.user.UserLookup;
import io.crate.breaker.BlockBasedRamAccounting;
import io.crate.breaker.RowAccountingWithEstimators;
import io.crate.exceptions.SQLExceptions;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.protocols.http.Headers;
import io.crate.rest.action.HttpError;
import io.crate.rest.action.RestBulkRowCountReceiver;
import io.crate.rest.action.RestResultSetReceiver;
import io.crate.rest.action.RestRowCountReceiver;
import io.crate.rest.action.ResultToXContentBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class SqlHttpHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOGGER = LogManager.getLogger(SqlHttpHandler.class);
    private static final String REQUEST_HEADER_USER = "User";
    private static final String REQUEST_HEADER_SCHEMA = "Default-Schema";
    private final Settings settings;
    private final SQLOperations sqlOperations;
    private final Function<String, CircuitBreaker> circuitBreakerProvider;
    private final UserLookup userLookup;
    private final Function<SessionContext, AccessControl> getAccessControl;
    private final Netty4CorsConfig corsConfig;
    private Session session;

    SqlHttpHandler(Settings settings, SQLOperations sqlOperations, Function<String, CircuitBreaker> circuitBreakerProvider, UserLookup userLookup, Function<SessionContext, AccessControl> getAccessControl, Netty4CorsConfig corsConfig) {
        super(false);
        this.settings = settings;
        this.sqlOperations = sqlOperations;
        this.circuitBreakerProvider = circuitBreakerProvider;
        this.userLookup = userLookup;
        this.getAccessControl = getAccessControl;
        this.corsConfig = corsConfig;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (request.uri().startsWith("/_sql")) {
            Session session = this.ensureSession(request);
            Map parameters = new QueryStringDecoder(request.uri()).parameters();
            ByteBuf content = request.content();
            this.handleSQLRequest(session, content, SqlHttpHandler.paramContainFlag(parameters, "types")).whenComplete((result, t) -> {
                try {
                    this.sendResponse(session, ctx, request, parameters, (XContentBuilder)result, (Throwable)t);
                }
                catch (Throwable ex) {
                    LOGGER.error("Error sending response", ex);
                    throw ex;
                }
                finally {
                    request.release();
                }
            });
        } else {
            ctx.fireChannelRead((Object)request);
        }
    }

    private static boolean paramContainFlag(Map<String, List<String>> parameters, String flag) {
        List<String> values = parameters.get(flag);
        return values != null && (values.equals(Collections.singletonList("")) || values.equals(Collections.singletonList("true")));
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        super.channelUnregistered(ctx);
    }

    private void sendResponse(Session session, ChannelHandlerContext ctx, FullHttpRequest request, Map<String, List<String>> parameters, XContentBuilder result, @Nullable Throwable t) {
        DefaultFullHttpResponse resp;
        ByteBuf content;
        HttpVersion httpVersion = request.protocolVersion();
        if (t == null) {
            content = Netty4Utils.toByteBuf(BytesReference.bytes(result));
            resp = new DefaultFullHttpResponse(httpVersion, HttpResponseStatus.OK, content);
            resp.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)result.contentType().mediaType());
        } else {
            String mediaType;
            RuntimeException throwable = SQLExceptions.prepareForClientTransmission(this.getAccessControl.apply(session.sessionContext()), t);
            HttpError httpError = HttpError.fromThrowable(throwable);
            boolean includeErrorTrace = SqlHttpHandler.paramContainFlag(parameters, "error_trace");
            try (XContentBuilder contentBuilder = httpError.toXContent(includeErrorTrace);){
                content = Netty4Utils.toByteBuf(BytesReference.bytes(contentBuilder));
                mediaType = contentBuilder.contentType().mediaType();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            resp = new DefaultFullHttpResponse(httpVersion, httpError.httpResponseStatus(), content);
            resp.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
        }
        Netty4CorsHandler.setCorsResponseHeaders((HttpRequest)request, (HttpResponse)resp, this.corsConfig);
        resp.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(content.readableBytes()));
        boolean closeConnection = Headers.isCloseConnection(request);
        ChannelPromise promise = ctx.newPromise();
        if (closeConnection) {
            promise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            Headers.setKeepAlive(httpVersion, (FullHttpResponse)resp);
        }
        ctx.writeAndFlush((Object)resp, promise);
    }

    private CompletableFuture<XContentBuilder> handleSQLRequest(Session session, ByteBuf content, boolean includeTypes) {
        SQLRequestParseContext parseContext;
        try {
            parseContext = SQLRequestParser.parseSource(Netty4Utils.toBytesReference(content));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
        List<Object> args = parseContext.args();
        List<List<Object>> bulkArgs = parseContext.bulkArgs();
        if (SqlHttpHandler.bothProvided(args, bulkArgs)) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("request body contains args and bulk_args. It's forbidden to provide both"));
        }
        try {
            if (args != null || bulkArgs == null) {
                return this.executeSimpleRequest(session, parseContext.stmt(), args, includeTypes);
            }
            return this.executeBulkRequest(session, parseContext.stmt(), bulkArgs);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    private Session ensureSession(FullHttpRequest request) {
        String defaultSchema = request.headers().get(REQUEST_HEADER_SCHEMA);
        User authenticatedUser = this.userFromAuthHeader(request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION));
        Session session = this.session;
        if (session == null) {
            session = this.sqlOperations.createSession(defaultSchema, authenticatedUser);
        } else if (!session.sessionContext().authenticatedUser().equals(authenticatedUser)) {
            session.close();
            session = this.sqlOperations.createSession(defaultSchema, authenticatedUser);
        } else {
            SessionContext sessionContext = session.sessionContext();
            sessionContext.resetToDefaults();
            if (defaultSchema != null) {
                sessionContext.setSearchPath(defaultSchema);
            }
        }
        this.session = session;
        return session;
    }

    private CompletableFuture<XContentBuilder> executeSimpleRequest(Session session, String stmt, List<Object> args, boolean includeTypes) throws IOException {
        ResultReceiver<XContentBuilder> resultReceiver;
        long startTimeInNs = System.nanoTime();
        session.parse("", stmt, Collections.emptyList());
        session.bind("", "", args == null ? Collections.emptyList() : args, null);
        DescribeResult description = session.describe('P', "");
        List<Symbol> resultFields = description.getFields();
        if (resultFields == null) {
            resultReceiver = new RestRowCountReceiver(JsonXContent.contentBuilder(), startTimeInNs, includeTypes);
        } else {
            CircuitBreaker breaker = this.circuitBreakerProvider.apply("query");
            BlockBasedRamAccounting ramAccounting = new BlockBasedRamAccounting(b -> breaker.addEstimateBytesAndMaybeBreak(b, "http-result"), 0x200000);
            resultReceiver = new RestResultSetReceiver(JsonXContent.contentBuilder(), resultFields, startTimeInNs, new RowAccountingWithEstimators(Symbols.typeView(resultFields), ramAccounting), includeTypes);
            resultReceiver.completionFuture().whenComplete((result, error) -> ramAccounting.close());
        }
        session.execute("", 0, resultReceiver);
        return session.sync().thenCompose(ignored -> resultReceiver.completionFuture());
    }

    private CompletableFuture<XContentBuilder> executeBulkRequest(Session session, String stmt, List<List<Object>> bulkArgs) {
        DescribeResult describeResult;
        long startTimeInNs = System.nanoTime();
        session.parse("", stmt, Collections.emptyList());
        RestBulkRowCountReceiver.Result[] results = new RestBulkRowCountReceiver.Result[bulkArgs.size()];
        for (int i = 0; i < bulkArgs.size(); ++i) {
            session.bind("", "", bulkArgs.get(i), null);
            RestBulkRowCountReceiver resultReceiver = new RestBulkRowCountReceiver(results, i);
            session.execute("", 0, resultReceiver);
        }
        if (results.length > 0 && (describeResult = session.describe('P', "")).getFields() != null) {
            return CompletableFuture.failedFuture(new UnsupportedOperationException("Bulk operations for statements that return result sets is not supported"));
        }
        return session.sync().thenApply(ignored -> {
            try {
                return ResultToXContentBuilder.builder(JsonXContent.contentBuilder()).cols(Collections.emptyList()).duration(startTimeInNs).bulkRows(results).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    User userFromAuthHeader(@Nullable String authHeaderValue) {
        String username = Headers.extractCredentialsFromHttpBasicAuthHeader(authHeaderValue).v1();
        if (username == null || username.isEmpty()) {
            username = AuthSettings.AUTH_TRUST_HTTP_DEFAULT_HEADER.setting().get(this.settings);
        }
        return this.userLookup.findUser(username);
    }

    private static boolean bothProvided(@Nullable List<Object> args, @Nullable List<List<Object>> bulkArgs) {
        return args != null && !args.isEmpty() && bulkArgs != null && !bulkArgs.isEmpty();
    }
}

