/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.action.sql.SQLOperations;
import io.crate.auth.user.UserManager;
import io.crate.plugin.PipelineRegistry;
import io.crate.protocols.ssl.SslContextProvider;
import io.crate.rest.action.SqlHttpHandler;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

@Singleton
public class RestSQLAction {
    @Inject
    public RestSQLAction(Settings settings, SQLOperations sqlOperations, PipelineRegistry pipelineRegistry, Provider<UserManager> userManagerProvider, CircuitBreakerService breakerService, SslContextProvider sslContextProvider) {
        UserManager userManager = userManagerProvider.get();
        pipelineRegistry.addBefore(new PipelineRegistry.ChannelPipelineItem("handler", "sql_handler", corsConfig -> new SqlHttpHandler(settings, sqlOperations, breakerService::getBreaker, userManager, userManager::getAccessControl, (Netty4CorsConfig)corsConfig)));
        pipelineRegistry.setSslContextProvider(sslContextProvider);
    }
}

